import Image from "next/image"
import { ArrowRight } from "lucide-react"
import { Button } from "@/components/ui/button"
import PageHeader from "@/components/page-header"

export default function AboutPage() {
  return (
    <>
      <PageHeader
        title="À Propos de DOGES"
        description="25 ans d'expertise au service de votre patrimoine immobilier"
        breadcrumbs={[{ label: "À Propos", href: "/a-propos" }]}
        backgroundImage="https://images.unsplash.com/photo-1497366216548-37526070297c?q=80&w=2069&auto=format&fit=crop"
      />

      {/* Présentation */}
      <section className="py-16">
        <div className="container mx-auto px-4">
          <div className="grid lg:grid-cols-2 gap-12 items-center">
            <div>
              <h2 className="text-3xl font-bold mb-6 text-[#002395]">
                Doges est un cabinet spécialisé dans l'administration de biens immobiliers
              </h2>
              <p className="text-lg text-gray-700 mb-6">
                Nous offrons des services complets et de haute qualité en France pour répondre aux besoins de nos
                clients au meilleur tarif qui puisse exister.
              </p>
              <p className="text-lg text-gray-700 mb-6">
                En tant qu'experts en administration de biens immobiliers, nous proposons une solution clé en main pour
                la gestion locative. Nos services comprennent la recherche de locataires, la rédaction des contrats de
                location, la gestion des loyers et des charges, la résolution des litiges éventuels, ainsi que la
                gestion comptable. Nous nous assurons que vos biens sont bien entretenus et que les loyers sont perçus
                dans les meilleurs délais.
              </p>
              <p className="text-lg text-gray-700 mb-6">
                En plus de nos services de gestion locative, nous offrons également des services de location pour les
                propriétaires qui souhaitent louer leurs biens. Nous prenons en charge toutes les étapes du processus de
                location, de la mise en ligne des annonces à la signature du contrat de location.
              </p>
            </div>
            <div className="relative h-[500px] rounded-2xl overflow-hidden">
              <Image
                src="https://images.unsplash.com/photo-1486406146926-c627a92ad1ab?q=80&w=2070&auto=format&fit=crop"
                alt="Doges - Administration de biens"
                fill
                className="object-cover"
              />
            </div>
          </div>
        </div>
      </section>

      {/* Services */}
      <section className="py-16 bg-gray-50">
        <div className="container mx-auto px-4">
          <div className="grid lg:grid-cols-2 gap-12 items-center">
            <div className="relative h-[500px] rounded-2xl overflow-hidden order-2 lg:order-1">
              <Image
                src="https://images.unsplash.com/photo-1560518883-ce09059eeffa?q=80&w=2073&auto=format&fit=crop"
                alt="Services immobiliers Doges"
                fill
                className="object-cover"
              />
            </div>
            <div className="order-1 lg:order-2">
              <h2 className="text-3xl font-bold mb-6 text-[#002395]">Nos services immobiliers</h2>
              <p className="text-lg text-gray-700 mb-6">
                Pour les propriétaires qui souhaitent vendre leur bien immobilier, nous proposons des services de vente
                complets. Nous réalisons une estimation gratuite de votre bien, nous nous chargeons de la mise en ligne
                de l'annonce, de la visite des biens et de la négociation avec les acheteurs potentiels.
              </p>
              <p className="text-lg text-gray-700 mb-6">
                Chez Doges, la satisfaction de nos clients est notre priorité absolue. Nous nous efforçons de fournir un
                service de qualité supérieure à un prix compétitif à partir de 2% H.T. pour une gestion comptable
                simple. N'hésitez pas à nous contacter dès maintenant pour en savoir plus sur nos services et bénéficier
                d'un accompagnement personnalisé dans la gestion de vos biens immobiliers.
              </p>
            </div>
          </div>
        </div>
      </section>

      {/* Expertise */}
      <section className="py-16">
        <div className="container mx-auto px-4">
          <div className="grid lg:grid-cols-2 gap-12 items-center">
            <div>
              <h2 className="text-3xl font-bold mb-6 text-[#002395]">Notre expertise</h2>
              <p className="text-lg text-gray-700 mb-6">
                Grâce à notre expérience cumulée de plus de 25 ans dans le domaine de l'immobilier, nos fondateurs sont
                des experts reconnus dans l'administration de biens. Leur solide expertise dans la gestion locative, la
                location, la vente de biens immobiliers et la gestion de patrimoine immobilier nous permet de proposer
                des services de qualité supérieure.
              </p>
              <p className="text-lg text-gray-700 mb-6">
                Nos fondateurs ont travaillé dans les plus prestigieuses entreprises de gestion immobilière avant de
                créer Doges. Leur approche personnalisée de la gestion immobilière est basée sur une compréhension
                approfondie des besoins de chaque client et sur la proposition de solutions adaptées.
              </p>
              <p className="text-lg text-gray-700 mb-6">
                Avec notre équipe de professionnels de l'immobilier passionnés par l'excellence du service client, nous
                sommes en mesure de fournir des services de qualité supérieure à des prix compétitifs. Nous mettons à
                profit l'expérience et les connaissances approfondies de nos fondateurs pour offrir un service de
                premier ordre à nos clients.
              </p>
            </div>
            <div className="relative h-[500px] rounded-2xl overflow-hidden">
              <Image
                src="https://images.unsplash.com/photo-1600880292203-757bb62b4baf?q=80&w=2070&auto=format&fit=crop"
                alt="Expertise immobilière Doges"
                fill
                className="object-cover"
              />
            </div>
          </div>
        </div>
      </section>

      {/* CTA */}
      <section className="py-16 bg-gradient-to-r from-[#002395] to-[#001875] text-white">
        <div className="container mx-auto px-4 text-center">
          <h2 className="text-3xl font-bold mb-6">Prêt à nous confier votre bien ?</h2>
          <p className="text-xl mb-8 max-w-2xl mx-auto">
            Profitez dès maintenant de notre expertise en gestion immobilière et bénéficiez d'un accompagnement
            personnalisé dans la gestion de vos biens immobiliers. Contactez Doges pour en savoir plus sur nos services
            et pour découvrir comment nous pouvons répondre à vos besoins.
          </p>
          <div className="flex flex-col sm:flex-row justify-center gap-4">
            <Button className="bg-white text-[#002395] hover:bg-gray-100">
              Demander un devis
              <ArrowRight className="ml-2 h-4 w-4" />
            </Button>
            <Button variant="outline" className="border-white text-white hover:bg-white hover:text-[#002395]">
              Nous contacter
            </Button>
          </div>
        </div>
      </section>
    </>
  )
}
