import type { Metadata } from "next"
import { BlogArticleLayout } from "@/components/blog-article-layout"
import { getRelatedArticles, getPreviousArticle, getNextArticle } from "@/lib/blog-utils"

export const metadata: Metadata = {
  title: "Guide complet du propriétaire bailleur en 2025 | DOGES",
  description: "Tout ce que vous devez savoir pour gérer efficacement votre bien locatif en 2025.",
  alternates: {
    canonical: "https://www.dogesadb.fr/blog/articles/guide-proprietaire-bailleur-2025",
  },
}

const tableOfContents = [
  { id: "introduction", text: "Introduction", level: 1 },
  { id: "obligations-legales", text: "Obligations légales du propriétaire bailleur", level: 1 },
  { id: "diagnostics-obligatoires", text: "Les diagnostics obligatoires", level: 2 },
  { id: "bail-location", text: "Le bail de location", level: 2 },
  { id: "etat-des-lieux", text: "L'état des lieux", level: 2 },
  { id: "fiscalite", text: "Fiscalité immobilière pour les bailleurs", level: 1 },
  { id: "revenus-fonciers", text: "Déclaration des revenus fonciers", level: 2 },
  { id: "regimes-fiscaux", text: "Les différents régimes fiscaux", level: 2 },
  { id: "gestion-locative", text: "Gestion locative : faire soi-même ou déléguer ?", level: 1 },
  { id: "avantages-inconvenients", text: "Avantages et inconvénients", level: 2 },
  { id: "criteres-choix", text: "Critères de choix d'un gestionnaire", level: 2 },
  { id: "assurances", text: "Les assurances indispensables", level: 1 },
  { id: "gli", text: "L'assurance loyers impayés", level: 2 },
  { id: "pno", text: "L'assurance PNO", level: 2 },
  { id: "conclusion", text: "Conclusion", level: 1 },
]

export default function GuideBailleurPage() {
  const currentSlug = "guide-proprietaire-bailleur-2025"
  const relatedArticles = getRelatedArticles(currentSlug, "Gestion locative", 3)
  const previousArticle = getPreviousArticle(currentSlug)
  const nextArticle = getNextArticle(currentSlug)

  return (
    <BlogArticleLayout
      title="Guide complet du propriétaire bailleur en 2025"
      date="15 mars 2025"
      category="Gestion locative"
      readingTime="12 min"
      image="/professional-property-management.jpg"
      tableOfContents={tableOfContents}
      relatedArticles={relatedArticles}
      previousArticle={previousArticle}
      nextArticle={nextArticle}
      author={{
        name: "Bedis Iddir",
        role: "Expert en gestion locative",
        image: "/confident-leader.png",
        bio: "Bedis Iddir est expert en gestion locative avec plus de 15 ans d'expérience dans l'immobilier parisien. Il conseille les propriétaires bailleurs pour optimiser leurs investissements.",
        linkedin: "https://www.linkedin.com/in/bedis-iddir/",
      }}
    >
      <h1 id="introduction">Guide complet du propriétaire bailleur en 2025</h1>

      <p>
        Être propriétaire bailleur en 2025 implique de nombreuses responsabilités et obligations. Ce guide complet vous
        accompagne à travers les aspects essentiels de la gestion locative pour vous aider à optimiser votre
        investissement tout en respectant la réglementation en vigueur.
      </p>

      <h2 id="obligations-legales">Obligations légales du propriétaire bailleur</h2>

      <p>
        En tant que propriétaire bailleur, vous êtes soumis à un cadre juridique strict qui définit vos obligations
        envers votre locataire. Ces obligations ont été renforcées ces dernières années, notamment en matière de
        performance énergétique des logements.
      </p>

      <h3 id="diagnostics-obligatoires">Les diagnostics obligatoires</h3>

      <p>
        Avant de mettre votre bien en location, vous devez réaliser plusieurs diagnostics techniques qui seront
        regroupés dans le Dossier de Diagnostic Technique (DDT) :
      </p>

      <ul>
        <li>
          <strong>DPE (Diagnostic de Performance Énergétique)</strong> : Depuis le 1er janvier 2025, les logements
          classés F et G (passoires thermiques) ne peuvent plus être proposés à la location.
        </li>
        <li>
          <strong>Diagnostic amiante</strong> : Obligatoire pour les logements construits avant 1997.
        </li>
        <li>
          <strong>État des risques naturels et technologiques</strong> : Informe le locataire des risques auxquels le
          bien est exposé.
        </li>
        <li>
          <strong>Diagnostic plomb</strong> : Obligatoire pour les logements construits avant 1949.
        </li>
        <li>
          <strong>Diagnostic électricité et gaz</strong> : Obligatoire si les installations ont plus de 15 ans.
        </li>
      </ul>

      <h3 id="bail-location">Le bail de location</h3>

      <p>Le contrat de bail doit respecter un formalisme précis et inclure certaines mentions obligatoires :</p>

      <ul>
        <li>Identité des parties (bailleur et locataire)</li>
        <li>Description du logement et sa destination</li>
        <li>Date de prise d'effet et durée du bail</li>
        <li>Montant du loyer et modalités de paiement</li>
        <li>Montant du dépôt de garantie</li>
        <li>Clause de révision du loyer</li>
        <li>Liste des équipements d'usage commun</li>
        <li>Montant et détail des charges récupérables</li>
      </ul>

      <p>
        En 2025, les baux numériques sont devenus la norme, avec signature électronique sécurisée pour faciliter les
        démarches à distance.
      </p>

      <h3 id="etat-des-lieux">L'état des lieux</h3>

      <p>
        L'état des lieux d'entrée et de sortie est obligatoire. Il doit être joint au contrat de bail et établi de façon
        contradictoire. Les applications mobiles dédiées permettent désormais de réaliser des états des lieux numériques
        avec photos horodatées et géolocalisées, limitant les contestations ultérieures.
      </p>

      <h2 id="fiscalite">Fiscalité immobilière pour les bailleurs</h2>

      <p>
        La fiscalité immobilière est un aspect crucial de votre investissement locatif. Une bonne connaissance des
        règles fiscales vous permettra d'optimiser votre rendement.
      </p>

      <h3 id="revenus-fonciers">Déclaration des revenus fonciers</h3>

      <p>
        Les revenus issus de la location nue (non meublée) sont imposés dans la catégorie des revenus fonciers. Vous
        devez déclarer :
      </p>

      <ul>
        <li>Les loyers perçus</li>
        <li>Les charges déductibles (travaux, frais de gestion, assurances, etc.)</li>
        <li>Les intérêts d'emprunt</li>
      </ul>

      <h3 id="regimes-fiscaux">Les différents régimes fiscaux</h3>

      <p>Deux régimes s'offrent à vous pour la location nue :</p>

      <ul>
        <li>
          <strong>Le régime micro-foncier</strong> : Si vos revenus locatifs bruts ne dépassent pas 15 000 € par an,
          vous bénéficiez d'un abattement forfaitaire de 30% sur vos revenus.
        </li>
        <li>
          <strong>Le régime réel</strong> : Vous déduisez vos charges réelles de vos revenus locatifs. Ce régime est
          souvent plus avantageux si vous avez des charges importantes ou des travaux à réaliser.
        </li>
      </ul>

      <p>
        Pour la location meublée, vous pouvez opter pour le statut de Loueur en Meublé Non Professionnel (LMNP) qui
        permet de bénéficier d'avantages fiscaux supplémentaires, notamment l'amortissement du bien.
      </p>

      <h2 id="gestion-locative">Gestion locative : faire soi-même ou déléguer ?</h2>

      <p>
        La gestion de votre bien locatif peut être chronophage et complexe. Vous avez le choix entre gérer vous-même ou
        faire appel à un professionnel.
      </p>

      <h3 id="avantages-inconvenients">Avantages et inconvénients</h3>

      <p>
        <strong>Gestion en direct :</strong>
      </p>

      <ul>
        <li>
          <strong>Avantages</strong> : Économie des frais de gestion, relation directe avec le locataire, maîtrise
          totale des décisions.
        </li>
        <li>
          <strong>Inconvénients</strong> : Chronophage, nécessite des connaissances juridiques, gestion des problèmes
          techniques, risque d'impayés.
        </li>
      </ul>

      <p>
        <strong>Gestion déléguée :</strong>
      </p>

      <ul>
        <li>
          <strong>Avantages</strong> : Gain de temps, expertise professionnelle, sécurisation des loyers, déduction
          fiscale des honoraires.
        </li>
        <li>
          <strong>Inconvénients</strong> : Coût (généralement entre 6% et 10% des loyers), perte de contrôle direct,
          qualité de service variable selon les agences.
        </li>
      </ul>

      <h3 id="criteres-choix">Critères de choix d'un gestionnaire</h3>

      <p>Si vous optez pour une gestion déléguée, voici les critères à considérer :</p>

      <ul>
        <li>Réputation et avis clients</li>
        <li>Transparence des honoraires</li>
        <li>Étendue des services proposés</li>
        <li>Réactivité et disponibilité</li>
        <li>Outils digitaux mis à disposition</li>
        <li>Connaissance du marché local</li>
      </ul>

      <h2 id="assurances">Les assurances indispensables</h2>

      <p>Pour sécuriser votre investissement locatif, certaines assurances sont essentielles, voire obligatoires.</p>

      <h3 id="gli">L'assurance loyers impayés</h3>

      <p>
        La Garantie des Loyers Impayés (GLI) vous protège contre les risques d'impayés, les dégradations locatives et
        les frais de contentieux. Son coût varie entre 2% et 4% des loyers annuels, mais c'est une sécurité précieuse,
        surtout dans un contexte économique incertain.
      </p>

      <h3 id="pno">L'assurance PNO</h3>

      <p>
        L'assurance Propriétaire Non Occupant (PNO) est obligatoire. Elle couvre les risques liés à votre responsabilité
        civile de propriétaire (dégât des eaux affectant un voisin, incendie, etc.) que l'assurance du locataire ne
        prend pas en charge.
      </p>

      <h2 id="conclusion">Conclusion</h2>

      <p>
        Être propriétaire bailleur en 2025 nécessite de jongler avec de nombreuses obligations légales, fiscales et
        administratives. Une bonne connaissance de ces aspects et une gestion rigoureuse vous permettront de sécuriser
        votre investissement et d'en optimiser la rentabilité.
      </p>

      <p>
        N'hésitez pas à vous faire accompagner par des professionnels (gestionnaire, comptable, avocat fiscaliste) pour
        vous aider dans cette démarche. L'investissement dans ces services est souvent rentabilisé par les économies
        réalisées et la sérénité gagnée.
      </p>
    </BlogArticleLayout>
  )
}
