import type { Metadata } from "next"
import BlogArticleLayout from "@/components/blog-article-layout"

export const metadata: Metadata = {
  title: "Les Nouvelles Obligations des Propriétaires Face à la Transition Énergétique | Doges",
  description:
    "Découvrez les nouvelles obligations des propriétaires face à la transition énergétique, les échéances à respecter et les aides financières disponibles pour vous accompagner.",
  openGraph: {
    title: "Les Nouvelles Obligations des Propriétaires Face à la Transition Énergétique | Doges",
    description:
      "Découvrez les nouvelles obligations des propriétaires face à la transition énergétique, les échéances à respecter et les aides financières disponibles pour vous accompagner.",
    images: [{ url: "/dpe-energy-label.png", width: 1200, height: 630 }],
  },
}

const tableOfContents = {
  items: [
    { title: "Introduction", url: "#introduction" },
    { title: "Le cadre réglementaire de la transition énergétique", url: "#cadre-reglementaire" },
    { title: "La loi Climat et Résilience", url: "#loi-climat-resilience" },
    { title: "Le décret tertiaire", url: "#decret-tertiaire" },
    { title: "Les obligations des propriétaires", url: "#obligations-proprietaires" },
    { title: "L'audit énergétique obligatoire", url: "#audit-energetique" },
    { title: "L'interdiction progressive de location des passoires thermiques", url: "#interdiction-location" },
    { title: "Le plan pluriannuel de travaux", url: "#plan-pluriannuel" },
    { title: "Les échéances clés à retenir", url: "#echeances-cles" },
    { title: "Calendrier 2023-2034", url: "#calendrier-2023-2034" },
    { title: "Sanctions en cas de non-conformité", url: "#sanctions-non-conformite" },
    { title: "Les aides financières pour la rénovation énergétique", url: "#aides-financieres" },
    { title: "MaPrimeRénov'", url: "#maprimerenv" },
    { title: "L'éco-prêt à taux zéro", url: "#eco-ptz" },
    { title: "La TVA à taux réduit", url: "#tva-reduite" },
    { title: "Les dispositifs de défiscalisation", url: "#defiscalisation" },
    { title: "Stratégies pour les propriétaires", url: "#strategies-proprietaires" },
    { title: "Anticiper les travaux", url: "#anticiper-travaux" },
    { title: "Optimiser ses investissements", url: "#optimiser-investissements" },
    { title: "Valoriser son bien immobilier", url: "#valoriser-bien" },
    { title: "Conclusion", url: "#conclusion" },
    { title: "Questions fréquentes", url: "#faq" },
  ],
}

const author = {
  name: "Bedis Iddir",
  title: "Expert en gestion locative",
  image: "/experts/bedis-iddir.jpg",
  linkedin: "https://www.linkedin.com/in/bedis-iddir/",
}

const relatedArticles = [
  {
    slug: "dpe-2024-changements-proprietaires",
    title: "DPE 2024 : Ce Qui Change pour les Propriétaires Bailleurs",
    description: "Découvrez les nouvelles règles du DPE et leur impact sur la location de votre bien immobilier.",
    image: "/dpe-energy-rating.png",
  },
  {
    slug: "travaux-renovation-valeur-locative",
    title: "Quels travaux de rénovation privilégier pour augmenter la valeur locative ?",
    description: "Guide des rénovations les plus rentables pour valoriser votre bien locatif.",
    image: "/renovation-apartment-valeur.png",
  },
]

const previousArticle = {
  slug: "encadrement-loyers-paris-bilan",
  title: "Encadrement des loyers à Paris : bilan après 5 ans",
}

const nextArticle = {
  slug: "erreurs-gestion-locative-eviter",
  title: "Les 7 erreurs à éviter en gestion locative",
}

export default function ObligationsTransitionEnergetique() {
  return (
    <BlogArticleLayout
      title="Les Nouvelles Obligations des Propriétaires Face à la Transition Énergétique"
      date="20 février 2025"
      category="Réglementation"
      readingTime="11 min"
      image="/dpe-energy-label.png"
      tableOfContents={tableOfContents}
      author={author}
      previousArticle={previousArticle}
      nextArticle={nextArticle}
      relatedArticles={relatedArticles}
    >
      <h2 id="introduction">Introduction</h2>
      <p>
        La transition énergétique est devenue un enjeu majeur pour le secteur immobilier en France. Face à l'urgence
        climatique, le gouvernement a mis en place un cadre réglementaire de plus en plus strict, imposant aux
        propriétaires de nombreuses obligations pour améliorer la performance énergétique de leurs biens. Ces nouvelles
        mesures visent à réduire la consommation d'énergie des bâtiments, qui représentent près de 45% de la
        consommation énergétique nationale et 25% des émissions de gaz à effet de serre.
      </p>
      <p>
        Pour les propriétaires bailleurs ou occupants, ces obligations représentent à la fois un défi financier et
        technique, mais aussi une opportunité de valoriser leur patrimoine immobilier. Dans cet article, nous vous
        présentons un panorama complet des nouvelles obligations liées à la transition énergétique, les échéances à
        respecter et les aides financières disponibles pour vous accompagner dans cette démarche.
      </p>

      <h2 id="cadre-reglementaire">Le cadre réglementaire de la transition énergétique</h2>

      <h3 id="loi-climat-resilience">La loi Climat et Résilience</h3>
      <p>
        Promulguée le 22 août 2021, la loi Climat et Résilience constitue le pilier central de la politique de
        transition énergétique dans le secteur immobilier. Elle fixe des objectifs ambitieux pour réduire les émissions
        de gaz à effet de serre et lutter contre les passoires thermiques. Parmi ses mesures phares :
      </p>
      <ul>
        <li>L'interdiction progressive de la location des logements énergivores</li>
        <li>L'obligation d'un audit énergétique pour la vente de certains biens</li>
        <li>La mise en place d'un carnet d'information du logement</li>
        <li>Le renforcement du Diagnostic de Performance Énergétique (DPE)</li>
      </ul>

      <div className="relative w-full h-[300px] my-6 rounded-lg overflow-hidden">
        <img
          src="/dpe-classes-comparison.png"
          alt="Comparaison des classes énergétiques DPE"
          className="object-contain w-full h-full"
        />
      </div>

      <h3 id="decret-tertiaire">Le décret tertiaire</h3>
      <p>
        Pour les propriétaires de bâtiments à usage tertiaire (bureaux, commerces, hôtels, etc.) de plus de 1000 m², le
        décret tertiaire impose une réduction progressive de la consommation d'énergie :
      </p>
      <ul>
        <li>-40% d'ici 2030</li>
        <li>-50% d'ici 2040</li>
        <li>-60% d'ici 2050</li>
      </ul>
      <p>
        Ces objectifs sont calculés par rapport à une année de référence qui ne peut être antérieure à 2010. Les
        propriétaires concernés doivent déclarer leurs consommations énergétiques annuelles sur la plateforme OPERAT
        gérée par l'ADEME.
      </p>

      <div className="relative w-full h-[300px] my-6 rounded-lg overflow-hidden">
        <img
          src="/energy-consumption-reduction.png"
          alt="Graphique montrant la réduction progressive de consommation énergétique"
          className="object-contain w-full h-full"
        />
      </div>

      <h2 id="obligations-proprietaires">Les obligations des propriétaires</h2>

      <h3 id="audit-energetique">L'audit énergétique obligatoire</h3>
      <p>
        Depuis le 1er avril 2023, la vente d'un logement classé F ou G au DPE doit être accompagnée d'un audit
        énergétique. Cette obligation sera étendue aux logements classés E à partir du 1er janvier 2025, puis aux
        logements classés D à partir du 1er janvier 2034.
      </p>
      <p>L'audit énergétique va plus loin que le DPE en proposant :</p>
      <ul>
        <li>Un état des lieux complet du logement</li>
        <li>Des scénarios de travaux pour atteindre une classe énergétique plus performante</li>
        <li>Une estimation du coût des travaux et des économies d'énergie générées</li>
        <li>Des informations sur les aides financières disponibles</li>
      </ul>

      <div className="relative w-full h-[300px] my-6 rounded-lg overflow-hidden">
        <img
          src="/energy-audit-process.png"
          alt="Processus d'audit énergétique d'un logement"
          className="object-contain w-full h-full"
        />
      </div>

      <h3 id="interdiction-location">L'interdiction progressive de location des passoires thermiques</h3>
      <p>
        La loi Climat et Résilience a instauré un calendrier d'interdiction progressive de mise en location des
        logements énergivores :
      </p>
      <ul>
        <li>Depuis le 1er janvier 2023 : interdiction d'augmenter le loyer des logements classés F et G</li>
        <li>À partir du 1er janvier 2025 : interdiction de louer les logements classés G</li>
        <li>À partir du 1er janvier 2028 : interdiction de louer les logements classés F</li>
        <li>À partir du 1er janvier 2034 : interdiction de louer les logements classés E</li>
      </ul>

      <h3 id="plan-pluriannuel">Le plan pluriannuel de travaux</h3>
      <p>
        Pour les copropriétés de plus de 15 ans, la loi ALUR renforcée par la loi Climat et Résilience impose la
        réalisation d'un diagnostic technique global (DTG) et la mise en place d'un plan pluriannuel de travaux (PPT) :
      </p>
      <ul>
        <li>Depuis le 1er janvier 2023 : copropriétés de plus de 200 lots</li>
        <li>À partir du 1er janvier 2024 : copropriétés de 51 à 200 lots</li>
        <li>À partir du 1er janvier 2025 : copropriétés de moins de 50 lots</li>
      </ul>
      <p>
        Ce plan pluriannuel doit prévoir les travaux nécessaires à la conservation de l'immeuble, à la réduction des
        consommations énergétiques et à la mise en conformité des équipements communs sur une période de 10 ans.
      </p>

      <div className="relative w-full h-[300px] my-6 rounded-lg overflow-hidden">
        <img
          src="/building-renovation-plan.png"
          alt="Plan de rénovation énergétique d'un immeuble"
          className="object-contain w-full h-full"
        />
      </div>

      <h2 id="echeances-cles">Les échéances clés à retenir</h2>

      <h3 id="calendrier-2023-2034">Calendrier 2023-2034</h3>
      <div className="bg-gray-100 p-4 rounded-lg my-4">
        <h4 className="font-semibold">2023</h4>
        <ul className="list-disc pl-5">
          <li>Gel des loyers pour les passoires thermiques (DPE F et G)</li>
          <li>Audit énergétique obligatoire pour la vente des logements classés F ou G</li>
          <li>Plan pluriannuel de travaux pour les grandes copropriétés</li>
        </ul>

        <h4 className="font-semibold mt-3">2024</h4>
        <ul className="list-disc pl-5">
          <li>Plan pluriannuel de travaux pour les copropriétés moyennes</li>
        </ul>

        <h4 className="font-semibold mt-3">2025</h4>
        <ul className="list-disc pl-5">
          <li>Interdiction de louer les logements classés G</li>
          <li>Audit énergétique obligatoire pour la vente des logements classés E</li>
          <li>Plan pluriannuel de travaux pour les petites copropriétés</li>
        </ul>

        <h4 className="font-semibold mt-3">2028</h4>
        <ul className="list-disc pl-5">
          <li>Interdiction de louer les logements classés F</li>
        </ul>

        <h4 className="font-semibold mt-3">2034</h4>
        <ul className="list-disc pl-5">
          <li>Interdiction de louer les logements classés E</li>
          <li>Audit énergétique obligatoire pour la vente des logements classés D</li>
        </ul>
      </div>

      <h3 id="sanctions-non-conformite">Sanctions en cas de non-conformité</h3>
      <p>Le non-respect des obligations liées à la transition énergétique peut entraîner différentes sanctions :</p>
      <ul>
        <li>Pour la location d'un logement interdit : jusqu'à 15 000 € d'amende</li>
        <li>Pour l'absence d'audit énergétique lors d'une vente : nullité de la vente à la demande de l'acquéreur</li>
        <li>
          Pour le non-respect du décret tertiaire : amende administrative pouvant aller jusqu'à 1 500 € pour les
          personnes physiques et 7 500 € pour les personnes morales
        </li>
        <li>Pour l'absence de plan pluriannuel de travaux en copropriété : majoration des charges de copropriété</li>
      </ul>

      <div className="relative w-full h-[250px] my-6 rounded-lg overflow-hidden">
        <img
          src="/compliance-warning.png"
          alt="Avertissement sur les sanctions en cas de non-conformité"
          className="object-contain w-full h-full"
        />
      </div>

      <h2 id="aides-financieres">Les aides financières pour la rénovation énergétique</h2>

      <h3 id="maprimerenv">MaPrimeRénov'</h3>
      <p>
        Principal dispositif d'aide à la rénovation énergétique, MaPrimeRénov' est accessible à tous les propriétaires,
        qu'ils soient occupants ou bailleurs. Le montant de l'aide varie selon :
      </p>
      <ul>
        <li>Les revenus du foyer</li>
        <li>Le gain énergétique apporté par les travaux</li>
        <li>La nature des travaux réalisés</li>
      </ul>
      <p>
        Pour les rénovations globales permettant un gain énergétique d'au moins 35%, les aides peuvent atteindre jusqu'à
        35 000 €.
      </p>

      <div className="relative w-full h-[300px] my-6 rounded-lg overflow-hidden">
        <img
          src="/financial-aid-chart.png"
          alt="Graphique des aides financières disponibles pour la rénovation énergétique"
          className="object-contain w-full h-full"
        />
      </div>

      <h3 id="eco-ptz">L'éco-prêt à taux zéro</h3>
      <p>
        L'éco-PTZ permet de financer jusqu'à 50 000 € de travaux de rénovation énergétique sans intérêts. Sa durée de
        remboursement peut aller jusqu'à 20 ans. Il est cumulable avec MaPrimeRénov' et peut être accordé sans condition
        de ressources.
      </p>

      <h3 id="tva-reduite">La TVA à taux réduit</h3>
      <p>
        Les travaux de rénovation énergétique bénéficient d'une TVA à taux réduit de 5,5% au lieu de 20%. Cette
        réduction s'applique aux travaux d'amélioration de la qualité énergétique des logements achevés depuis plus de
        deux ans.
      </p>

      <h3 id="defiscalisation">Les dispositifs de défiscalisation</h3>
      <p>
        Pour les propriétaires bailleurs, plusieurs dispositifs permettent de déduire les travaux de rénovation
        énergétique de leurs revenus fonciers :
      </p>
      <ul>
        <li>Le dispositif Denormandie dans l'ancien</li>
        <li>Le déficit foncier</li>
        <li>Le statut LMNP (Loueur Meublé Non Professionnel)</li>
      </ul>

      <h2 id="strategies-proprietaires">Stratégies pour les propriétaires</h2>

      <h3 id="anticiper-travaux">Anticiper les travaux</h3>
      <p>Face au calendrier contraignant des obligations énergétiques, l'anticipation est la clé :</p>
      <ul>
        <li>Réaliser un DPE volontaire pour connaître la classe énergétique de son bien</li>
        <li>Faire établir un audit énergétique pour identifier les travaux prioritaires</li>
        <li>Planifier les travaux sur plusieurs années pour étaler l'investissement</li>
        <li>Se renseigner sur les aides financières disponibles avant de lancer les travaux</li>
      </ul>

      <div className="relative w-full h-[300px] my-6 rounded-lg overflow-hidden">
        <img
          src="/renovation-planning.png"
          alt="Planification des travaux de rénovation énergétique"
          className="object-contain w-full h-full"
        />
      </div>

      <h3 id="optimiser-investissements">Optimiser ses investissements</h3>
      <p>Pour rentabiliser au mieux les travaux de rénovation énergétique :</p>
      <ul>
        <li>Privilégier les travaux à fort impact sur la performance énergétique (isolation, chauffage)</li>
        <li>Combiner plusieurs types de travaux pour bénéficier d'aides plus importantes</li>
        <li>Faire appel à des professionnels certifiés RGE (Reconnu Garant de l'Environnement)</li>
        <li>Comparer plusieurs devis avant de s'engager</li>
      </ul>

      <h3 id="valoriser-bien">Valoriser son bien immobilier</h3>
      <p>La rénovation énergétique est aussi un moyen de valoriser son patrimoine :</p>
      <ul>
        <li>Un logement bien isolé se vend en moyenne 15% plus cher qu'un logement énergivore</li>
        <li>Les économies d'énergie générées augmentent le pouvoir d'achat des occupants</li>
        <li>Un bien performant énergétiquement attire davantage de locataires et limite la vacance locative</li>
        <li>La valeur verte des biens immobiliers ne cesse de croître avec la prise de conscience écologique</li>
      </ul>

      <div className="relative w-full h-[300px] my-6 rounded-lg overflow-hidden">
        <img
          src="/property-value-increase.png"
          alt="Augmentation de la valeur immobilière après rénovation énergétique"
          className="object-contain w-full h-full"
        />
      </div>

      <h2 id="conclusion">Conclusion</h2>
      <p>
        La transition énergétique impose de nouvelles contraintes aux propriétaires, mais elle représente aussi une
        opportunité de moderniser et de valoriser leur patrimoine immobilier. En anticipant les échéances réglementaires
        et en s'appuyant sur les dispositifs d'aide disponibles, il est possible de transformer cette obligation en
        investissement rentable.
      </p>
      <p>
        Chez Doges, nous accompagnons les propriétaires dans cette démarche en leur proposant un diagnostic personnalisé
        et des solutions adaptées à leur situation. N'hésitez pas à nous contacter pour bénéficier de notre expertise en
        matière de rénovation énergétique et de gestion locative.
      </p>

      <h2 id="faq">Questions fréquentes</h2>

      <div className="space-y-4 mt-4">
        <div className="border-b pb-4">
          <h3 className="font-semibold">Qu'est-ce qu'une passoire thermique ?</h3>
          <p>
            Une passoire thermique désigne un logement très énergivore, classé F ou G au Diagnostic de Performance
            Énergétique (DPE). Ces logements consomment généralement plus de 330 kWh/m²/an d'énergie primaire.
          </p>
        </div>

        <div className="border-b pb-4">
          <h3 className="font-semibold">
            Comment savoir si mon logement est concerné par l'interdiction de location ?
          </h3>
          <p>
            Pour savoir si votre logement est concerné, vous devez consulter son DPE. Si celui-ci est classé G, il sera
            interdit à la location à partir de 2025. S'il est classé F, l'interdiction s'appliquera à partir de 2028, et
            pour les logements classés E, à partir de 2034.
          </p>
        </div>

        <div className="border-b pb-4">
          <h3 className="font-semibold">Puis-je encore vendre un logement classé G ?</h3>
          <p>
            Oui, la vente des logements énergivores reste possible, mais depuis le 1er avril 2023, vous devez fournir un
            audit énergétique à l'acheteur pour les logements classés F ou G. Cet audit doit proposer des scénarios de
            travaux pour améliorer la performance énergétique du bien.
          </p>
        </div>

        <div className="border-b pb-4">
          <h3 className="font-semibold">Les aides financières sont-elles cumulables ?</h3>
          <p>
            Oui, la plupart des aides sont cumulables entre elles, dans certaines limites. Par exemple, MaPrimeRénov'
            peut être cumulée avec l'éco-PTZ, les CEE (Certificats d'Économie d'Énergie) et la TVA à taux réduit.
            Toutefois, le cumul des aides ne peut pas dépasser 90% du coût total des travaux pour les ménages aux
            revenus très modestes, et 75% pour les autres ménages.
          </p>
        </div>

        <div>
          <h3 className="font-semibold">Que risque-t-on en cas de location d'un logement interdit ?</h3>
          <p>
            La location d'un logement ne respectant pas les critères de performance énergétique peut être sanctionnée
            par une amende administrative pouvant aller jusqu'à 15 000 €. De plus, le locataire pourrait demander au
            propriétaire de réaliser des travaux de mise en conformité, voire obtenir une réduction de loyer.
          </p>
        </div>
      </div>
    </BlogArticleLayout>
  )
}
