"use client"

import { useState } from "react"
import { Calculator, Home, TrendingUp, BarChart3 } from "lucide-react"
import Link from "next/link"
import FeeCalculator from "@/components/fee-calculator"
import MortgageCalculator from "@/components/mortgage-calculator"
import TransactionCalculator from "@/components/transaction-calculator-widget"
import RentabiliteCalculator from "@/components/rentabilite-calculator"

type CalculatorType = "gestion" | "pret" | "transaction" | "rentabilite"

export default function CalculateursClient() {
  const [activeCalculator, setActiveCalculator] = useState<CalculatorType>("gestion")

  const calculatorDescriptions = {
    gestion:
      "Estimez vos frais de gestion locative en fonction du loyer, du type de bien et du niveau de service souhaité.",
    pret: "Simulez votre prêt immobilier et calculez vos mensualités en fonction du montant, du taux et de la durée.",
    transaction:
      "Estimez tous les frais liés à une transaction immobilière : frais de notaire, honoraires d'agence, plus-values.",
    rentabilite:
      "Évaluez la rentabilité de votre investissement locatif en prenant en compte tous les paramètres importants.",
  }

  return (
    <section className="py-12 bg-gray-50">
      <div className="container mx-auto px-4">
        <div className="max-w-4xl mx-auto">
          <div className="text-center mb-12">
            <h2 className="text-3xl font-bold text-[#002395] mb-4">Nos Calculateurs Immobiliers</h2>
            <p className="text-lg text-gray-700">
              Des outils gratuits et précis pour vous aider dans toutes vos démarches immobilières. Que vous soyez
              propriétaire, investisseur ou à la recherche d'un bien, nos calculateurs vous permettent d'obtenir des
              estimations fiables en quelques clics.
            </p>
          </div>

          {/* Tabs */}
          <div className="grid grid-cols-2 md:grid-cols-4 gap-2 mb-8">
            <button
              onClick={() => setActiveCalculator("gestion")}
              className={`flex items-center justify-center gap-2 p-4 rounded-lg transition-colors ${
                activeCalculator === "gestion"
                  ? "bg-[#002395] text-white"
                  : "bg-white text-gray-700 hover:bg-gray-100 border border-gray-200"
              }`}
            >
              <Calculator size={20} />
              <span className="font-medium">Frais de Gestion</span>
            </button>
            <button
              onClick={() => setActiveCalculator("pret")}
              className={`flex items-center justify-center gap-2 p-4 rounded-lg transition-colors ${
                activeCalculator === "pret"
                  ? "bg-[#002395] text-white"
                  : "bg-white text-gray-700 hover:bg-gray-100 border border-gray-200"
              }`}
            >
              <Home size={20} />
              <span className="font-medium">Prêt Immobilier</span>
            </button>
            <button
              onClick={() => setActiveCalculator("transaction")}
              className={`flex items-center justify-center gap-2 p-4 rounded-lg transition-colors ${
                activeCalculator === "transaction"
                  ? "bg-[#002395] text-white"
                  : "bg-white text-gray-700 hover:bg-gray-100 border border-gray-200"
              }`}
            >
              <TrendingUp size={20} />
              <span className="font-medium">Transaction</span>
            </button>
            <button
              onClick={() => setActiveCalculator("rentabilite")}
              className={`flex items-center justify-center gap-2 p-4 rounded-lg transition-colors ${
                activeCalculator === "rentabilite"
                  ? "bg-[#002395] text-white"
                  : "bg-white text-gray-700 hover:bg-gray-100 border border-gray-200"
              }`}
            >
              <BarChart3 size={20} />
              <span className="font-medium">Rentabilité</span>
            </button>
          </div>

          {/* Description */}
          <div className="bg-white p-6 rounded-lg shadow-sm mb-8 text-center">
            <p className="text-gray-700">{calculatorDescriptions[activeCalculator]}</p>
          </div>

          {/* Calculator */}
          <div className="bg-white p-6 rounded-lg shadow-md">
            {activeCalculator === "gestion" && <FeeCalculator />}
            {activeCalculator === "pret" && <MortgageCalculator />}
            {activeCalculator === "transaction" && <TransactionCalculator />}
            {activeCalculator === "rentabilite" && <RentabiliteCalculator />}
          </div>

          {/* Call to Action */}
          <div className="mt-8 text-center bg-white p-8 rounded-lg shadow-sm">
            <h3 className="text-2xl font-bold text-[#002395] mb-4">Besoin d'un accompagnement personnalisé ?</h3>
            <p className="text-gray-700 mb-6">
              Nos experts sont à votre disposition pour vous conseiller et vous accompagner dans votre projet
              immobilier. Contactez-nous pour une consultation gratuite et personnalisée.
            </p>
            <Link href="/contact">
              <button className="bg-[#002395] hover:bg-[#001875] text-white font-bold py-3 px-8 rounded-lg transition-colors duration-300">
                Contactez nos experts
              </button>
            </Link>
          </div>

          {/* Disclaimer */}
          <div className="mt-8 text-center text-sm text-gray-500">
            <p>
              Les résultats fournis par ces calculateurs sont des estimations et peuvent varier en fonction de votre
              situation personnelle et des conditions du marché. Pour des conseils personnalisés, n'hésitez pas à{" "}
              <Link href="/contact" className="text-[#002395] hover:underline">
                nous contacter
              </Link>
              .
            </p>
          </div>
        </div>
      </div>
    </section>
  )
}
