import Image from "next/image"
import { ArrowRight, Check } from "lucide-react"
import { Button } from "@/components/ui/button"
import PageHeader from "@/components/page-header"

export default function CarrieresPage() {
  // Offres d'emploi
  const jobOffers = [
    {
      title: "Gestionnaire de copropriété H/F",
      location: "Paris 8ème",
      type: "CDI",
      description:
        "Vous serez en charge de la gestion administrative, comptable et technique d'un portefeuille de copropriétés. Vous assurerez la préparation et la tenue des assemblées générales, le suivi des décisions et la relation avec les conseils syndicaux.",
      requirements: [
        "Formation en immobilier (BTS, Licence)",
        "Expérience de 2 ans minimum en gestion de copropriété",
        "Maîtrise des outils informatiques",
        "Rigueur, organisation et sens du relationnel",
      ],
    },
    {
      title: "Négociateur immobilier H/F",
      location: "Paris 16ème",
      type: "CDI",
      description:
        "Au sein de notre agence du 16ème arrondissement, vous serez en charge de la prospection, de l'estimation et de la vente de biens immobiliers. Vous accompagnerez les clients vendeurs et acquéreurs tout au long de leur projet.",
      requirements: [
        "Formation commerciale ou immobilière",
        "Expérience en vente immobilière souhaitée",
        "Excellent relationnel et sens de la négociation",
        "Connaissance du marché immobilier parisien",
      ],
    },
    {
      title: "Gestionnaire locatif H/F",
      location: "Neuilly-sur-Seine",
      type: "CDI",
      description:
        "Vous serez en charge de la gestion d'un portefeuille de biens locatifs. Vos missions incluront la mise en location, la rédaction des baux, les états des lieux, le suivi des loyers et charges, la gestion des travaux et la relation avec les propriétaires et locataires.",
      requirements: [
        "Formation en immobilier (BTS, Licence)",
        "Expérience de 2 ans minimum en gestion locative",
        "Maîtrise des outils informatiques",
        "Rigueur, organisation et sens du relationnel",
      ],
    },
    {
      title: "Assistant(e) administratif(ve) H/F",
      location: "Paris 8ème",
      type: "CDI",
      description:
        "Au sein de notre siège social, vous assurerez le support administratif des équipes de gestion et de transaction. Vos missions incluront l'accueil téléphonique et physique, la gestion du courrier, la préparation de documents et le suivi administratif des dossiers.",
      requirements: [
        "Formation en secrétariat ou assistanat",
        "Expérience de 2 ans minimum dans un poste similaire",
        "Maîtrise des outils bureautiques",
        "Rigueur, organisation et sens du relationnel",
      ],
    },
  ]

  // Avantages
  const benefits = [
    {
      title: "Rémunération attractive",
      description: "Salaire fixe compétitif + variable selon les performances + participation aux bénéfices",
    },
    {
      title: "Formation continue",
      description: "Programme de formation personnalisé pour développer vos compétences et évoluer dans l'entreprise",
    },
    {
      title: "Équilibre vie pro/perso",
      description: "Horaires flexibles, télétravail partiel possible selon les postes, et respect de votre vie privée",
    },
    {
      title: "Ambiance conviviale",
      description: "Équipe soudée, événements d'entreprise réguliers et cadre de travail agréable",
    },
    {
      title: "Évolution de carrière",
      description: "Possibilités d'évolution interne et accompagnement dans votre développement professionnel",
    },
    {
      title: "Avantages sociaux",
      description: "Mutuelle d'entreprise, tickets restaurant, participation aux frais de transport",
    },
  ]

  return (
    <>
      <PageHeader
        title="Rejoignez DOGES"
        description="Découvrez nos opportunités de carrière et rejoignez une équipe passionnée"
        breadcrumbs={[{ label: "Carrières", href: "/carrieres" }]}
        backgroundImage="https://images.unsplash.com/photo-1600880292203-757bb62b4baf?q=80&w=2070&auto=format&fit=crop"
      />

      {/* Notre culture */}
      <section className="py-16">
        <div className="container mx-auto px-4">
          <div className="grid lg:grid-cols-2 gap-12 items-center">
            <div>
              <h2 className="text-3xl font-bold mb-6 text-[#002395]">Notre culture d'entreprise</h2>
              <p className="text-lg text-gray-700 mb-6">
                Chez DOGES, nous cultivons un environnement de travail basé sur la confiance, le respect et
                l'excellence. Nous croyons que le succès de notre entreprise repose sur le talent et l'engagement de nos
                collaborateurs.
              </p>
              <p className="text-lg text-gray-700 mb-6">
                Nous encourageons l'innovation, la prise d'initiative et le développement personnel. Chaque membre de
                notre équipe est valorisé pour sa contribution unique et bénéficie d'opportunités d'évolution au sein de
                l'entreprise.
              </p>
              <p className="text-lg text-gray-700">
                Rejoindre DOGES, c'est intégrer une équipe passionnée par l'immobilier et dédiée à offrir un service
                d'excellence à nos clients.
              </p>
            </div>
            <div className="relative h-[400px] rounded-2xl overflow-hidden">
              <Image
                src="https://images.unsplash.com/photo-1600880292089-90a7e086ee0c?q=80&w=2070&auto=format&fit=crop"
                alt="Culture d'entreprise DOGES"
                fill
                className="object-cover"
              />
            </div>
          </div>
        </div>
      </section>

      {/* Nos valeurs */}
      <section className="py-16 bg-gray-50">
        <div className="container mx-auto px-4">
          <h2 className="text-3xl font-bold mb-12 text-center text-[#002395]">Nos valeurs</h2>
          <div className="grid md:grid-cols-4 gap-4">
            {[
              {
                title: "Excellence",
                description:
                  "Nous visons l'excellence dans chaque aspect de notre travail, de la relation client à la gestion technique.",
                icon: "🏆",
              },
              {
                title: "Intégrité",
                description:
                  "Nous agissons avec honnêteté et transparence dans toutes nos interactions professionnelles.",
                icon: "⚖️",
              },
              {
                title: "Innovation",
                description: "Nous encourageons la créativité et l'innovation pour améliorer constamment nos services.",
                icon: "💡",
              },
              {
                title: "Respect",
                description:
                  "Nous traitons chaque personne avec respect et considération, qu'il s'agisse de clients ou de collègues.",
                icon: "🤝",
              },
              {
                title: "Engagement",
                description: "Nous sommes dédiés à la satisfaction de nos clients et au succès de notre entreprise.",
                icon: "🎯",
              },
              {
                title: "Esprit d'équipe",
                description:
                  "Nous croyons en la force du collectif et encourageons la collaboration entre tous les membres de l'équipe.",
                icon: "👥",
              },
              {
                title: "Inclusivité",
                description:
                  "Nous valorisons la diversité et l'inclusion, quelle que soit le genre ou l'origine de chacun, pour créer un environnement de travail enrichissant.",
                icon: "🌈",
              },
              {
                title: "Écologie",
                description:
                  "Nous nous engageons à adopter des pratiques écologiques dans notre activité quotidienne et à promouvoir la durabilité dans le secteur immobilier.",
                icon: "🌱",
              },
            ].map((value, index) => (
              <div key={index} className="bg-white rounded-xl shadow-sm p-5 text-center">
                <div className="text-4xl mb-4">{value.icon}</div>
                <h3 className="text-xl font-bold mb-3">{value.title}</h3>
                <p className="text-gray-700">{value.description}</p>
              </div>
            ))}
          </div>
        </div>
      </section>

      {/* Offres d'emploi */}
      <section className="py-16">
        <div className="container mx-auto px-4">
          <h2 className="text-3xl font-bold mb-12 text-center text-[#002395]">Nos offres d'emploi</h2>

          <div className="space-y-8">
            {jobOffers.map((job, index) => (
              <div key={index} className="bg-white rounded-xl shadow-sm overflow-hidden border border-gray-100">
                <div className="p-6">
                  <div className="flex flex-col md:flex-row md:items-center md:justify-between mb-4">
                    <h3 className="text-xl font-bold text-[#002395]">{job.title}</h3>
                    <div className="flex items-center mt-2 md:mt-0">
                      <span className="bg-gray-100 text-gray-800 text-sm px-3 py-1 rounded-full mr-2">
                        {job.location}
                      </span>
                      <span className="bg-[#002395] text-white text-sm px-3 py-1 rounded-full">{job.type}</span>
                    </div>
                  </div>
                  <p className="text-gray-700 mb-4">{job.description}</p>
                  <div className="mb-6">
                    <h4 className="font-semibold mb-2">Profil recherché :</h4>
                    <ul className="space-y-2">
                      {job.requirements.map((req, idx) => (
                        <li key={idx} className="flex items-start">
                          <Check className="h-5 w-5 text-[#002395] mr-2 mt-0.5" />
                          <span>{req}</span>
                        </li>
                      ))}
                    </ul>
                  </div>
                  <Button className="bg-gradient-to-r from-[#002395] to-[#001875]">
                    Postuler
                    <ArrowRight className="ml-2 h-4 w-4" />
                  </Button>
                </div>
              </div>
            ))}
          </div>
        </div>
      </section>

      {/* Avantages */}
      <section className="py-16 bg-gray-50">
        <div className="container mx-auto px-4">
          <h2 className="text-3xl font-bold mb-12 text-center text-[#002395]">Pourquoi nous rejoindre ?</h2>

          <div className="grid md:grid-cols-3 gap-8">
            {benefits.map((benefit, index) => (
              <div key={index} className="bg-white rounded-xl shadow-sm p-6 border border-gray-100">
                <h3 className="text-xl font-bold mb-3">{benefit.title}</h3>
                <p className="text-gray-700">{benefit.description}</p>
              </div>
            ))}
          </div>
        </div>
      </section>

      {/* Témoignages */}
      <section className="py-16">
        <div className="container mx-auto px-4">
          <h2 className="text-3xl font-bold mb-12 text-center text-[#002395]">Ils travaillent chez DOGES</h2>

          <div className="grid md:grid-cols-2 gap-8">
            {[
              {
                name: "Sophie Martin",
                role: "Gestionnaire locative depuis 5 ans",
                image: "/placeholder.svg?height=100&width=100",
                quote:
                  "Rejoindre DOGES a été une excellente décision pour ma carrière. J'apprécie particulièrement l'ambiance de travail et les possibilités d'évolution. En 5 ans, j'ai pu développer mes compétences et prendre de nouvelles responsabilités.",
              },
              {
                name: "Thomas Dubois",
                role: "Négociateur immobilier depuis 3 ans",
                image: "/placeholder.svg?height=100&width=100",
                quote:
                  "Rejoindre DOGES a été une excellente décision pour ma carrière. J'apprécie particulièrement l'ambiance de travail et les possibilités d'évolution. En 5 ans, j'ai pu développer mes compétences et prendre de nouvelles responsabilités.",
              },
              {
                name: "Thomas Dubois",
                role: "Négociateur immobilier depuis 3 ans",
                image: "/placeholder.svg?height=100&width=100",
                quote:
                  "DOGES m'a offert l'opportunité de développer mes compétences en vente immobilière et de travailler sur des projets stimulants. L'esprit d'équipe et l'accompagnement de la direction sont très appréciables.",
              },
            ].map((testimonial, index) => (
              <div key={index} className="bg-white rounded-xl shadow-sm p-6 border border-gray-100">
                <div className="flex items-center mb-4">
                  <Image
                    src={testimonial.image || "/placeholder.svg"}
                    alt={testimonial.name}
                    width={60}
                    height={60}
                    className="rounded-full mr-4"
                  />
                  <div>
                    <h3 className="text-xl font-bold">{testimonial.name}</h3>
                    <p className="text-gray-600">{testimonial.role}</p>
                  </div>
                </div>
                <p className="text-gray-700">{testimonial.quote}</p>
              </div>
            ))}
          </div>
        </div>
      </section>

      {/* Contact */}
      <section className="py-16 bg-gray-50">
        <div className="container mx-auto px-4">
          <h2 className="text-3xl font-bold mb-12 text-center text-[#002395]">Contactez-nous</h2>
          <p className="text-lg text-gray-700 text-center mb-8">
            Vous souhaitez en savoir plus sur nos opportunités de carrière ou nous envoyer votre candidature spontanée ?
            N'hésitez pas à nous contacter.
          </p>
          <div className="flex justify-center">
            <Button className="bg-gradient-to-r from-[#002395] to-[#001875]">
              Nous contacter
              <ArrowRight className="ml-2 h-4 w-4" />
            </Button>
          </div>
        </div>
      </section>

      {/* 2. Page Ressources */}
    </>
  )
}
