import type { Metadata } from "next"
import Link from "next/link"
import { TableOfContents } from "@/components/table-of-contents"
import ServiceHeader from "@/components/service-header"
import ContactWidget from "@/components/contact-widget"
import ServicesSidebarWidgets from "@/components/services-sidebar-widgets"
import { MapPin, UserCheck, Laptop, Eye, DollarSign, Clock } from "lucide-react"

export const metadata: Metadata = {
  title: "Comparatif des Gestionnaires Immobiliers | DOGES",
  description:
    "Comparez les services, tarifs et avantages des principaux gestionnaires immobiliers à Paris et en Île-de-France pour faire le meilleur choix pour votre bien.",
  alternates: {
    canonical: "https://www.dogesadb.fr/comparatif-gestionnaires-immobiliers",
  },
}

export default function ComparatifGestionnairesPage() {
  const tableOfContents = [
    { id: "introduction", title: "Introduction", level: 2 },
    { id: "criteres-comparaison", title: "Critères de comparaison", level: 2 },
    { id: "grands-groupes", title: "Les grands groupes immobiliers", level: 2 },
    { id: "independants", title: "Les gestionnaires indépendants", level: 2 },
    { id: "doges-difference", title: "La différence DOGES", level: 2 },
    { id: "tableau-comparatif", title: "Tableau comparatif détaillé", level: 2 },
    { id: "conclusion", title: "Comment choisir le bon gestionnaire", level: 2 },
  ]

  const breadcrumbItems = [
    { name: "Accueil", url: "/" },
    { name: "Comparatif des Gestionnaires Immobiliers", url: "/comparatif-gestionnaires-immobiliers" },
  ]

  return (
    <div className="min-h-screen">
      {/* En-tête standard avec ServiceHeader */}
      <ServiceHeader
        title="Comparatif des Gestionnaires Immobiliers"
        description="Trouvez le gestionnaire immobilier idéal pour votre bien en comparant services, tarifs et avantages"
        breadcrumbItems={breadcrumbItems}
        backgroundImage="/comparatif-gestionnaires-header.png"
      />

      {/* Contenu principal */}
      <div className="container mx-auto px-4 py-8">
        <div className="grid grid-cols-1 lg:grid-cols-4 gap-10 mt-8">
          <div className="lg:col-span-3">
            <section className="prose max-w-none">
              <script
                type="application/ld+json"
                dangerouslySetInnerHTML={{
                  __html: JSON.stringify({
                    "@context": "https://schema.org",
                    "@type": "WebPage",
                    speakable: {
                      "@type": "SpeakableSpecification",
                      cssSelector: ["h1", "h2", ".introduction"],
                    },
                    name: "Comparatif des Gestionnaires Immobiliers à Paris",
                    description:
                      "Comparaison détaillée des principaux gestionnaires immobiliers à Paris : services, tarifs, avantages et inconvénients pour vous aider à faire le meilleur choix.",
                    mainEntity: {
                      "@type": "Table",
                      about: "Comparaison des gestionnaires immobiliers",
                    },
                  }),
                }}
              />

              <h2 id="introduction">Introduction au marché de la gestion immobilière</h2>
              <p>
                Le choix d'un gestionnaire immobilier est une décision cruciale pour tout propriétaire souhaitant
                déléguer la gestion de son bien. Entre les grands groupes nationaux, les agences locales et les
                gestionnaires indépendants, l'offre est vaste et parfois difficile à décrypter. Ce comparatif vous aide
                à y voir plus clair pour faire un choix éclairé.
              </p>
              <p>
                La gestion immobilière en France représente un marché de plus de 3 milliards d'euros, avec des acteurs
                aux profils très variés. À Paris et en Île-de-France, la concurrence est particulièrement intense, ce
                qui peut compliquer la tâche des propriétaires dans leur recherche du partenaire idéal.
              </p>

              <h2 id="criteres-comparaison">Les critères essentiels de comparaison</h2>
              <p>
                Pour comparer efficacement les différents gestionnaires immobiliers, plusieurs critères doivent être
                pris en compte :
              </p>
              <ul>
                <li>
                  <strong>Tarification</strong> : honoraires de gestion, frais annexes, transparence des coûts
                </li>
                <li>
                  <strong>Services inclus</strong> : étendue des prestations de base et options disponibles
                </li>
                <li>
                  <strong>Réactivité</strong> : délais de réponse aux propriétaires et locataires
                </li>
                <li>
                  <strong>Expertise locale</strong> : connaissance du marché immobilier de votre quartier
                </li>
                <li>
                  <strong>Digitalisation</strong> : outils en ligne, espace client, dématérialisation
                </li>
                <li>
                  <strong>Garanties</strong> : assurances proposées, garantie loyers impayés
                </li>
                <li>
                  <strong>Transparence</strong> : reporting, accès aux documents, communication
                </li>
              </ul>

              <h2 id="grands-groupes">Les grands groupes immobiliers : forces et faiblesses</h2>
              <p>
                Les grands groupes nationaux comme Foncia, Nexity, Citya ou Century 21 disposent d'une force de frappe
                importante et d'une notoriété établie. Ils offrent généralement :
              </p>
              <ul>
                <li>Une présence géographique étendue</li>
                <li>Des outils digitaux développés</li>
                <li>Une large gamme de services complémentaires</li>
                <li>Des processus standardisés</li>
              </ul>
              <p>Cependant, ils présentent aussi certains inconvénients :</p>
              <ul>
                <li>Un turnover parfois élevé des gestionnaires</li>
                <li>Une approche souvent moins personnalisée</li>
                <li>Des frais généralement plus élevés</li>
                <li>Une réactivité parfois limitée par les procédures internes</li>
              </ul>

              <h2 id="independants">Les gestionnaires indépendants : l'alternative de proximité</h2>
              <p>Les cabinets indépendants et les gestionnaires locaux se distinguent par :</p>
              <ul>
                <li>Une connaissance approfondie du marché local</li>
                <li>Un suivi personnalisé et une relation de proximité</li>
                <li>Une plus grande flexibilité dans les services proposés</li>
                <li>Souvent, des honoraires plus compétitifs</li>
              </ul>
              <p>Leurs limites peuvent inclure :</p>
              <ul>
                <li>Des ressources plus limitées en cas de croissance du portefeuille</li>
                <li>Une digitalisation parfois moins avancée</li>
                <li>Une couverture géographique restreinte</li>
              </ul>

              <h2 id="doges-difference">La différence DOGES : le meilleur des deux mondes</h2>
              <p>
                DOGES se positionne comme une alternative innovante combinant les avantages des grands groupes et des
                indépendants :
              </p>

              {/* Section visuelle avec des boîtes et des icônes */}
              <div className="grid grid-cols-1 md:grid-cols-2 gap-6 my-8 not-prose">
                <div className="bg-white p-6 rounded-lg border border-gray-200 shadow-sm hover:shadow-md transition-shadow">
                  <div className="flex items-start">
                    <div className="bg-[#002395] p-3 rounded-full mr-4">
                      <MapPin className="h-6 w-6 text-white" />
                    </div>
                    <div>
                      <h3 className="font-bold text-lg mb-2">Expertise locale</h3>
                      <p className="text-gray-600">
                        Une connaissance approfondie de Paris et de l'Île-de-France pour une gestion adaptée à chaque
                        quartier.
                      </p>
                    </div>
                  </div>
                </div>

                <div className="bg-white p-6 rounded-lg border border-gray-200 shadow-sm hover:shadow-md transition-shadow">
                  <div className="flex items-start">
                    <div className="bg-[#002395] p-3 rounded-full mr-4">
                      <UserCheck className="h-6 w-6 text-white" />
                    </div>
                    <div>
                      <h3 className="font-bold text-lg mb-2">Service personnalisé</h3>
                      <p className="text-gray-600">
                        Un gestionnaire dédié pour chaque propriétaire, assurant un suivi sur mesure de votre bien.
                      </p>
                    </div>
                  </div>
                </div>

                <div className="bg-white p-6 rounded-lg border border-gray-200 shadow-sm hover:shadow-md transition-shadow">
                  <div className="flex items-start">
                    <div className="bg-[#002395] p-3 rounded-full mr-4">
                      <Laptop className="h-6 w-6 text-white" />
                    </div>
                    <div>
                      <h3 className="font-bold text-lg mb-2">Digitalisation avancée</h3>
                      <p className="text-gray-600">
                        Plateforme en ligne, signature électronique et espace client pour une gestion moderne et
                        efficace.
                      </p>
                    </div>
                  </div>
                </div>

                <div className="bg-white p-6 rounded-lg border border-gray-200 shadow-sm hover:shadow-md transition-shadow">
                  <div className="flex items-start">
                    <div className="bg-[#002395] p-3 rounded-full mr-4">
                      <Eye className="h-6 w-6 text-white" />
                    </div>
                    <div>
                      <h3 className="font-bold text-lg mb-2">Transparence totale</h3>
                      <p className="text-gray-600">
                        Accès en temps réel à tous les documents et transactions liés à votre bien immobilier.
                      </p>
                    </div>
                  </div>
                </div>

                <div className="bg-white p-6 rounded-lg border border-gray-200 shadow-sm hover:shadow-md transition-shadow">
                  <div className="flex items-start">
                    <div className="bg-[#002395] p-3 rounded-full mr-4">
                      <DollarSign className="h-6 w-6 text-white" />
                    </div>
                    <div>
                      <h3 className="font-bold text-lg mb-2">Tarification claire</h3>
                      <p className="text-gray-600">
                        Pas de frais cachés, des honoraires compétitifs et une grille tarifaire transparente.
                      </p>
                    </div>
                  </div>
                </div>

                <div className="bg-white p-6 rounded-lg border border-gray-200 shadow-sm hover:shadow-md transition-shadow">
                  <div className="flex items-start">
                    <div className="bg-[#002395] p-3 rounded-full mr-4">
                      <Clock className="h-6 w-6 text-white" />
                    </div>
                    <div>
                      <h3 className="font-bold text-lg mb-2">Réactivité garantie</h3>
                      <p className="text-gray-600">
                        Engagement sur des délais de réponse pour une gestion proactive de votre patrimoine.
                      </p>
                    </div>
                  </div>
                </div>
              </div>

              <h2 id="tableau-comparatif">Tableau comparatif détaillé</h2>
              <div className="overflow-x-auto">
                <table className="min-w-full bg-white border border-gray-300">
                  <thead>
                    <tr className="bg-gray-100">
                      <th className="border px-4 py-2">Critères</th>
                      <th className="border px-4 py-2">Grands groupes</th>
                      <th className="border px-4 py-2">Indépendants</th>
                      <th className="border px-4 py-2">DOGES</th>
                    </tr>
                  </thead>
                  <tbody>
                    <tr>
                      <td className="border px-4 py-2 font-medium">Honoraires de gestion</td>
                      <td className="border px-4 py-2">7-10% des loyers</td>
                      <td className="border px-4 py-2">5-8% des loyers</td>
                      <td className="border px-4 py-2">6-7% des loyers</td>
                    </tr>
                    <tr>
                      <td className="border px-4 py-2 font-medium">Frais de mise en location</td>
                      <td className="border px-4 py-2">8-12€/m²</td>
                      <td className="border px-4 py-2">7-10€/m²</td>
                      <td className="border px-4 py-2">8€/m²</td>
                    </tr>
                    <tr>
                      <td className="border px-4 py-2 font-medium">Garantie loyers impayés</td>
                      <td className="border px-4 py-2">2.5-3.5% des loyers</td>
                      <td className="border px-4 py-2">2.2-3% des loyers</td>
                      <td className="border px-4 py-2">2.2% des loyers</td>
                    </tr>
                    <tr>
                      <td className="border px-4 py-2 font-medium">Délai moyen de relocation</td>
                      <td className="border px-4 py-2">30-45 jours</td>
                      <td className="border px-4 py-2">Variable</td>
                      <td className="border px-4 py-2">21 jours</td>
                    </tr>
                    <tr>
                      <td className="border px-4 py-2 font-medium">Espace client en ligne</td>
                      <td className="border px-4 py-2">Oui</td>
                      <td className="border px-4 py-2">Parfois</td>
                      <td className="border px-4 py-2">Oui, avancé</td>
                    </tr>
                    <tr>
                      <td className="border px-4 py-2 font-medium">Gestionnaire dédié</td>
                      <td className="border px-4 py-2">Rarement</td>
                      <td className="border px-4 py-2">Souvent</td>
                      <td className="border px-4 py-2">Systématiquement</td>
                    </tr>
                    <tr>
                      <td className="border px-4 py-2 font-medium">Accompagnement travaux</td>
                      <td className="border px-4 py-2">Avec surcoût</td>
                      <td className="border px-4 py-2">Variable</td>
                      <td className="border px-4 py-2">Inclus</td>
                    </tr>
                    <tr>
                      <td className="border px-4 py-2 font-medium">Conseil fiscal</td>
                      <td className="border px-4 py-2">Basique</td>
                      <td className="border px-4 py-2">Variable</td>
                      <td className="border px-4 py-2">Personnalisé</td>
                    </tr>
                  </tbody>
                </table>
              </div>

              <h2 id="conclusion">Comment choisir le bon gestionnaire pour votre bien</h2>
              <p>
                Le choix d'un gestionnaire immobilier doit se faire en fonction de vos besoins spécifiques et de vos
                priorités :
              </p>
              <ul>
                <li>
                  <strong>Pour un investisseur avec plusieurs biens</strong> : privilégiez un gestionnaire offrant des
                  outils digitaux performants et une vision consolidée de votre patrimoine
                </li>
                <li>
                  <strong>Pour un propriétaire occupant temporairement absent</strong> : la réactivité et la proximité
                  seront essentielles
                </li>
                <li>
                  <strong>Pour un primo-bailleur</strong> : l'accompagnement et le conseil feront la différence
                </li>
                <li>
                  <strong>Pour un bien atypique ou haut de gamme</strong> : l'expertise spécifique du gestionnaire sera
                  déterminante
                </li>
              </ul>
              <p>
                N'hésitez pas à rencontrer plusieurs gestionnaires avant de faire votre choix. Chez DOGES, nous
                proposons un premier rendez-vous sans engagement pour évaluer vos besoins et vous présenter notre
                approche personnalisée.
              </p>

              <div className="bg-blue-50 p-6 rounded-lg mt-8 border border-blue-200">
                <h3 className="text-xl font-semibold text-blue-800">Besoin d'un avis personnalisé ?</h3>
                <p className="mb-4">
                  Nos experts sont à votre disposition pour analyser votre situation et vous recommander la solution de
                  gestion la plus adaptée à votre bien.
                </p>
                <Link
                  href="/contact"
                  className="inline-block bg-blue-600 text-white px-6 py-2 rounded-md hover:bg-blue-700 transition-colors"
                >
                  Demander un conseil personnalisé
                </Link>
              </div>
            </section>
          </div>

          <div className="lg:col-span-1">
            <div className="sticky top-20 space-y-6">
              <TableOfContents items={tableOfContents} />

              {/* Widget de contact rapide */}
              <ContactWidget />

              {/* Widget de services liés */}
              <ServicesSidebarWidgets />

              <div className="bg-gray-50 p-4 rounded-lg border border-gray-200">
                <h3 className="font-semibold text-lg mb-2">Vous êtes propriétaire ?</h3>
                <p className="text-sm mb-4">
                  Découvrez nos services de gestion locative sur mesure et nos honoraires compétitifs.
                </p>
                <Link href="/services/gestion-locative" className="text-sm text-blue-600 hover:underline block mb-2">
                  → Nos services de gestion locative
                </Link>
                <Link href="/tarifs" className="text-sm text-blue-600 hover:underline block">
                  → Nos honoraires
                </Link>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  )
}
