"use client"

import { useState, useEffect } from "react"
import { useSearchParams } from "next/navigation"
import { Mail, Phone, MapPin } from "lucide-react"
import PageHeader from "@/components/page-header"
import { ContactTabs } from "@/components/contact-tabs"
import DevisForm from "@/components/devis-form"
import SmartContactForm from "@/components/smart-contact-form"

export default function ContactPage() {
  const [activeTab, setActiveTab] = useState<"contact" | "devis">("contact")
  const searchParams = useSearchParams()

  useEffect(() => {
    const tab = searchParams.get("tab")
    if (tab === "devis") {
      setActiveTab("devis")
    }
  }, [searchParams])

  return (
    <>
      <PageHeader
        title="Contactez-nous"
        description="Notre équipe est à votre disposition pour répondre à toutes vos questions"
        breadcrumbs={[{ label: "Contact", href: "/contact" }]}
        backgroundImage="https://images.unsplash.com/photo-1560520653-9e0e4c89eb11?q=80&w=2073&auto=format&fit=crop"
      />

      <section className="py-16">
        <div className="container mx-auto px-4">
          <div className="grid lg:grid-cols-2 gap-12">
            {/* Formulaire de contact avec tabulation */}
            <div className="bg-white rounded-xl shadow-lg overflow-hidden border border-gray-100">
              <ContactTabs activeTab={activeTab} onChange={setActiveTab} />
              <div className="p-8">
                {activeTab === "contact" ? (
                  <div>
                    <h2 className="text-2xl font-bold mb-6 text-[#002395]">Envoyez-nous un message</h2>
                    <SmartContactForm />
                  </div>
                ) : (
                  <div>
                    <h2 className="text-2xl font-bold mb-6 text-[#002395]">Demande de devis gratuit</h2>
                    <DevisForm />
                  </div>
                )}
              </div>
            </div>

            {/* Informations de contact */}
            <div>
              <h2 className="text-2xl font-bold mb-6 text-[#002395]">L'AGENCE</h2>
              <p className="text-lg text-gray-700 mb-8">
                Doges est spécialisée dans la gestion immobilière en ligne. Nous proposons des services de qualité à des
                prix uniques en France pour répondre aux besoins de nos clients.
              </p>

              <div className="space-y-8">
                {/* Adresse principale */}
                <div className="bg-white rounded-xl shadow-sm p-6 border border-gray-100">
                  <h3 className="text-xl font-semibold mb-4">Notre agence à Paris</h3>
                  <div className="space-y-4">
                    <div className="flex items-start">
                      <MapPin className="h-5 w-5 text-[#002395] mr-3 mt-0.5" />
                      <span>92, Avenue de Saint-Mandé Paris 12e</span>
                    </div>
                    <div className="flex items-center">
                      <Phone className="h-5 w-5 text-[#002395] mr-3" />
                      <span>01 84 80 98 10</span>
                    </div>
                    <div className="flex items-center">
                      <Mail className="h-5 w-5 text-[#002395] mr-3" />
                      <a href="mailto:contact@dogesadb.fr" className="text-[#002395] hover:underline">
                        contact@dogesadb.fr
                      </a>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>

      {/* Carte */}
      <section className="py-16 bg-gray-50">
        <div className="container mx-auto px-4">
          <h2 className="text-2xl font-bold mb-8 text-center text-[#002395]">Notre emplacement</h2>
          <div className="h-[500px] rounded-xl overflow-hidden shadow-lg">
            <iframe
              src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d2625.6762329326247!2d2.4066742!3d48.8451422!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x47e672a5e5c0d6f9%3A0x2d0e8d1e3c0e5e9a!2s92%20Av.%20de%20Saint-Mand%C3%A9%2C%2075012%20Paris!5e0!3m2!1sfr!2sfr!4v1650000000000!5m2!1sfr!2sfr"
              width="100%"
              height="100%"
              style={{ border: 0 }}
              allowFullScreen
              loading="lazy"
              referrerPolicy="no-referrer-when-downgrade"
              title="Carte de l'agence DOGES"
            ></iframe>
          </div>
        </div>
      </section>

      {/* CTA */}
      <section className="py-16 bg-[#002395] text-white">
        <div className="container mx-auto px-4 text-center">
          <h2 className="text-3xl font-bold mb-6">Prêt à nous confier votre bien ?</h2>
          <p className="text-lg mb-8 max-w-3xl mx-auto">
            Bénéficiez de notre expertise et de notre engagement pour une gestion optimale de votre patrimoine
            immobilier.
          </p>
          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <a
              href="https://www.ringover.me/EU_X6dOeNDCcD+g58Q"
              className="inline-flex items-center justify-center bg-white text-[#002395] hover:bg-gray-100 px-8 py-3 rounded-lg font-medium"
            >
              Appelez-nous
            </a>
            <a
              href="#"
              onClick={(e) => {
                e.preventDefault()
                window.scrollTo({ top: 0, behavior: "smooth" })
                setActiveTab("devis")
              }}
              className="inline-flex items-center justify-center bg-transparent border-2 border-white text-white hover:bg-white/10 px-8 py-3 rounded-lg font-medium"
            >
              Confiez-nous votre bien
            </a>
          </div>
        </div>
      </section>
    </>
  )
}
