"use client"

import { useState } from "react"
import { ArrowRight, ChevronDown, ChevronUp, Search } from "lucide-react"
import { Button } from "@/components/ui/button"
import PageHeader from "@/components/page-header"
import Link from "next/link"

export default function FAQPage() {
  const [activeCategory, setActiveCategory] = useState("all")
  const [searchQuery, setSearchQuery] = useState("")
  const [openQuestions, setOpenQuestions] = useState<Record<string, boolean>>({})

  // Catégories de FAQ
  const faqCategories = [
    { id: "all", name: "Toutes les questions" },
    { id: "gestion", name: "Gestion Locative" },
    { id: "transaction", name: "Transactions" },
    { id: "gli", name: "Garantie Loyers Impayés" },
    { id: "pno", name: "Assurance PNO" },
    { id: "syndic", name: "Syndic de Copropriété" },
    { id: "specifique", name: "Questions spécifiques" },
  ]

  // Questions fréquentes
  const faqs = [
    // Questions existantes
    {
      id: "q1",
      question: "Quels sont les services inclus dans la gestion locative ?",
      answer:
        "Notre service de gestion locative comprend la recherche de locataires, la rédaction des baux, l'état des lieux, l'encaissement des loyers, la gestion des travaux et le suivi administratif complet. Selon le forfait choisi, des services supplémentaires peuvent être inclus comme la garantie loyers impayés, l'assurance PNO ou la représentation en assemblée générale.",
      category: "gestion",
    },
    {
      id: "q2",
      question: "Comment est calculée la commission sur les transactions ?",
      answer:
        "Notre commission est calculée en pourcentage du prix de vente du bien. Elle inclut l'ensemble de nos services : estimation, marketing, visites, négociation et suivi jusqu'à la signature. Le taux varie généralement entre 4% et 5% TTC selon le type et la valeur du bien. Pour un bien de grande valeur, ce taux peut être négocié.",
      category: "transaction",
    },
    {
      id: "q3",
      question: "Quelle est la durée d'engagement pour la gestion locative ?",
      answer:
        "Notre mandat de gestion est généralement d'une durée d'un an, renouvelable par tacite reconduction. Vous pouvez le résilier selon les conditions prévues au contrat, généralement avec un préavis de trois mois. Nous privilégions des relations de confiance sur le long terme avec nos clients.",
      category: "gestion",
    },
    {
      id: "q4",
      question: "Comment fonctionne la garantie loyers impayés ?",
      answer:
        "La garantie loyers impayés (GLI) est une assurance qui couvre le propriétaire en cas d'impayés de loyer. Elle prend en charge les loyers impayés, les frais de procédure et parfois les dégradations locatives. Pour en bénéficier, le locataire doit répondre à certains critères de solvabilité. Le coût est généralement de 2,5% à 3,5% des loyers annuels.",
      category: "gli",
    },
    {
      id: "q5",
      question: "Qu'est-ce que l'assurance PNO et pourquoi est-elle nécessaire ?",
      answer:
        "L'assurance Propriétaire Non Occupant (PNO) est obligatoire pour tout propriétaire qui loue son bien. Elle couvre les risques liés à la propriété du bien (dégâts des eaux, incendie, responsabilité civile, etc.) qui ne sont pas couverts par l'assurance du locataire. Son coût varie généralement entre 80€ et 150€ par an selon la superficie et les garanties choisies.",
      category: "pno",
    },
    {
      id: "q6",
      question: "Comment se passe la recherche de locataires ?",
      answer:
        "Nous mettons en place une stratégie de commercialisation complète : annonces sur les principaux portails immobiliers, diffusion sur notre site et nos réseaux sociaux, et activation de notre réseau de candidats. Nous effectuons une présélection rigoureuse des dossiers, organisons les visites et vous présentons les meilleurs candidats pour validation finale.",
      category: "gestion",
    },
    {
      id: "q7",
      question: "Quels sont les délais moyens pour vendre un bien ?",
      answer:
        "Les délais de vente varient selon le type de bien, sa localisation, son état et son prix. À Paris, le délai moyen est d'environ 45 à 60 jours entre la mise en vente et la signature du compromis. Notre connaissance approfondie du marché et notre réseau nous permettent souvent de réduire ce délai pour nos clients.",
      category: "transaction",
    },
    {
      id: "q8",
      question: "Comment sont gérés les travaux dans le bien loué ?",
      answer:
        "Pour les petits travaux d'entretien, nous disposons d'un réseau d'artisans qualifiés qui interviennent rapidement. Pour les travaux plus importants, nous vous consultons systématiquement et vous proposons plusieurs devis. Nous assurons ensuite le suivi des travaux jusqu'à leur bonne exécution et vous tenons informé à chaque étape.",
      category: "gestion",
    },
    {
      id: "q9",
      question: "Quels sont les avantages de faire appel à un syndic professionnel ?",
      answer:
        "Un syndic professionnel comme DOGES apporte une expertise juridique et technique, une disponibilité et une réactivité accrues, ainsi qu'une gestion rigoureuse des comptes de la copropriété. Nous assurons également une veille réglementaire constante pour garantir la conformité de votre copropriété avec les évolutions législatives.",
      category: "syndic",
    },
    {
      id: "q10",
      question: "Comment est calculé le loyer d'un bien ?",
      answer:
        "Le loyer est déterminé en fonction de plusieurs critères : la localisation du bien, sa superficie, son état, ses équipements, et les prix du marché local. Dans certaines zones tendues, le loyer peut être encadré par la loi. Nous réalisons une étude de marché précise pour vous proposer un loyer optimal, attractif pour les locataires tout en maximisant votre rentabilité.",
      category: "gestion",
    },
    {
      id: "q11",
      question: "Quelles sont les conditions pour bénéficier de la garantie loyers impayés ?",
      answer:
        "Pour bénéficier de la GLI, le locataire doit généralement justifier d'un taux d'effort (ratio loyer/revenus) inférieur à 33%, être en CDI hors période d'essai ou avoir un statut stable (fonctionnaire, retraité), et ne pas avoir d'incidents de paiement récents. Ces critères peuvent varier selon les assureurs avec lesquels nous travaillons.",
      category: "gli",
    },
    {
      id: "q12",
      question: "Comment se déroule une assemblée générale de copropriété ?",
      answer:
        "L'assemblée générale est convoquée au moins 21 jours à l'avance avec un ordre du jour détaillé. Lors de la réunion, le syndic présente les résolutions à voter. Chaque copropriétaire dispose d'un nombre de voix proportionnel à ses tantièmes. Les décisions sont prises à différentes majorités selon leur nature. Un procès-verbal est ensuite établi et envoyé à tous les copropriétaires.",
      category: "syndic",
    },
    {
      id: "q13",
      question: "Que faire en cas de sinistre dans mon bien loué ?",
      answer:
        "En cas de sinistre, contactez-nous immédiatement. Nous nous chargeons de faire les déclarations nécessaires auprès des assurances concernées (PNO, assurance du locataire, assurance de l'immeuble), de mandater les experts si nécessaire et de coordonner les travaux de remise en état. Nous vous tenons informé à chaque étape de la procédure.",
      category: "pno",
    },
    {
      id: "q14",
      question: "Comment est organisée la visite d'un bien à vendre ?",
      answer:
        "Nous organisons les visites en fonction de vos disponibilités et de celles des acquéreurs potentiels. Nous préparons un dossier de présentation complet du bien et de son environnement. Lors de la visite, notre conseiller met en valeur les atouts du bien et répond aux questions des visiteurs. Un compte-rendu vous est ensuite transmis après chaque visite.",
      category: "transaction",
    },
    {
      id: "q15",
      question: "Quelles sont les obligations du propriétaire en matière de diagnostics ?",
      answer:
        "Plusieurs diagnostics sont obligatoires pour la location ou la vente d'un bien : DPE, amiante, plomb, électricité, gaz, état des risques naturels et technologiques, etc. La liste varie selon l'âge du bien et sa localisation. Nous vous accompagnons dans la réalisation de ces diagnostics en faisant appel à des diagnostiqueurs certifiés partenaires.",
      category: "gestion",
    },

    // Nouvelles questions spécifiques de longue traîne
    {
      id: "q16",
      question: "Comment DOGES gère-t-il les logements soumis à l'encadrement des loyers à Paris ?",
      answer:
        "Pour les logements situés à Paris soumis à l'encadrement des loyers, nous déterminons précisément le loyer de référence selon les critères officiels (quartier, année de construction, meublé/non meublé). Nous calculons le loyer maximum autorisé en tenant compte du complément de loyer justifié par des caractéristiques exceptionnelles. Nous veillons à la conformité des annonces avec la mention du loyer de référence et nous assurons que les baux respectent la réglementation en vigueur. Notre expertise du marché parisien nous permet de fixer un loyer optimal tout en restant dans le cadre légal.",
      category: "gestion",
    },
    {
      id: "q17",
      question: "Quelles sont les spécificités de la gestion locative dans le 16ème arrondissement de Paris ?",
      answer:
        "La gestion locative dans le 16ème arrondissement présente plusieurs particularités : une clientèle exigeante composée souvent d'expatriés et de cadres supérieurs, des biens de standing nécessitant un suivi qualitatif, et des copropriétés avec des règlements stricts. Nous adaptons notre gestion avec un interlocuteur dédié parlant anglais, des visites plus fréquentes pour vérifier l'état du bien, et une connaissance approfondie des spécificités du marché local (prix au m², attentes des locataires). Notre agence située à proximité nous permet d'intervenir rapidement en cas de besoin et d'entretenir des relations privilégiées avec les gardiens d'immeubles du quartier.",
      category: "gestion",
    },
    {
      id: "q18",
      question: "Comment DOGES accompagne les propriétaires pour la mise en conformité DPE avant 2025 ?",
      answer:
        "Face à l'interdiction progressive de location des passoires thermiques (DPE F et G), nous proposons un accompagnement complet : réalisation d'un audit énergétique détaillé, élaboration d'un plan de travaux hiérarchisé et chiffré, mise en relation avec des artisans certifiés RGE, montage des dossiers d'aides financières (MaPrimeRénov', CEE, éco-PTZ), suivi et coordination des travaux, et contrôle post-travaux avec nouveau DPE. Nous pouvons également conseiller sur la rentabilité des investissements énergétiques et leur impact sur la valorisation du bien. Notre objectif est de transformer cette contrainte réglementaire en opportunité d'amélioration de votre patrimoine.",
      category: "gestion",
    },
    {
      id: "q19",
      question: "Quelles garanties spécifiques propose DOGES pour les propriétaires de logements de luxe ?",
      answer:
        "Pour les biens haut de gamme, nous proposons des garanties renforcées : une sélection ultra-rigoureuse des locataires avec vérification approfondie des références bancaires et professionnelles, une garantie loyers impayés premium couvrant jusqu'à 10 000€ de loyer mensuel, une assurance PNO étendue incluant les biens d'exception et œuvres d'art, des états des lieux réalisés par un expert en objets de valeur, et un service de conciergerie pour la maintenance. Nous effectuons également des visites de contrôle trimestrielles et proposons une garantie de remise en état complète en fin de bail. Ces services premium sont assurés par notre équipe dédiée aux biens d'exception.",
      category: "gli",
    },
    {
      id: "q20",
      question: "Comment DOGES gère-t-il les locations saisonnières et Airbnb à Paris ?",
      answer:
        "Notre gestion des locations saisonnières et Airbnb comprend : la vérification de la conformité légale (autorisation de changement d'usage, déclaration en mairie, respect des 120 jours maximum pour résidence principale), l'optimisation de l'annonce avec photographies professionnelles et description multilingue, la gestion complète des réservations et du calendrier sur les plateformes, l'accueil des voyageurs 7j/7 avec remise des clés, le ménage et la blanchisserie entre chaque séjour, et un reporting mensuel détaillé des performances. Nous gérons également la déclaration fiscale de vos revenus locatifs et vous conseillons sur le statut fiscal le plus avantageux (LMNP, micro-BIC). Notre connaissance des réglementations parisiennes vous évite tout risque d'amende.",
      category: "gestion",
    },
    {
      id: "q21",
      question: "Quelles sont les spécificités de l'assurance PNO pour un immeuble haussmannien à Paris ?",
      answer:
        "L'assurance PNO pour un immeuble haussmannien parisien nécessite des garanties spécifiques : couverture des éléments d'époque (moulures, parquets, cheminées en marbre) avec valeur de reconstruction à l'identique, protection renforcée contre les dégâts des eaux liés aux canalisations anciennes, garantie spécifique pour les éléments classés ou inscrits au patrimoine, couverture des risques liés aux travaux dans les appartements voisins (fissures, affaissements), et responsabilité civile étendue pour les parties communes à forte valeur patrimoniale. Nous négocions avec nos assureurs partenaires des contrats sur-mesure tenant compte de ces spécificités, avec des franchises adaptées et des plafonds d'indemnisation suffisants pour ces biens d'exception.",
      category: "pno",
    },
    {
      id: "q22",
      question: "Comment DOGES accompagne-t-il les investisseurs étrangers qui achètent à Paris ?",
      answer:
        "Notre accompagnement pour les investisseurs étrangers comprend : des conseils fiscaux et juridiques adaptés à leur pays de résidence (convention fiscale, IFI), l'ouverture d'un compte bancaire français, la mise en relation avec des notaires anglophones, la constitution d'une SCI si nécessaire, et la gestion administrative complète à distance. Nous proposons également un service de reporting financier trimestriel en anglais, la représentation aux assemblées générales de copropriété, et la gestion des obligations fiscales françaises (déclaration de revenus fonciers, prélèvements sociaux). Notre équipe multilingue (anglais, mandarin, arabe, russe) facilite les échanges et notre réseau de partenaires (comptables, avocats fiscalistes) sécurise votre investissement dans le respect des réglementations internationales.",
      category: "transaction",
    },
    {
      id: "q23",
      question: "Quelles solutions DOGES propose-t-il pour la gestion des copropriétés en difficulté financière ?",
      answer:
        "Face aux copropriétés en difficulté financière, nous mettons en place un plan de redressement structuré : audit complet des comptes et identification des sources de déséquilibre, plan d'apurement des dettes échelonné sur plusieurs exercices, procédures de recouvrement optimisées contre les copropriétaires débiteurs (relances graduées, mises en demeure, hypothèques légales), renégociation des contrats de maintenance pour réduire les charges, et recherche active de subventions (ANAH, plan Initiative Copropriétés). Nous organisons des réunions d'information régulières pour impliquer les copropriétaires dans le redressement et mettons en place un fonds travaux obligatoire pour anticiper les dépenses futures. Notre expérience dans la gestion de copropriétés en difficulté nous permet de rétablir l'équilibre financier tout en préservant la valeur patrimoniale de l'immeuble.",
      category: "syndic",
    },
    {
      id: "q24",
      question: "Comment DOGES gère-t-il la transition énergétique des copropriétés parisiennes ?",
      answer:
        "Notre approche de la transition énergétique des copropriétés parisiennes s'articule autour de plusieurs étapes : réalisation d'un diagnostic technique global (DTG) et d'un audit énergétique complet, élaboration d'un plan pluriannuel de travaux hiérarchisés, organisation d'ateliers pédagogiques pour sensibiliser les copropriétaires, montage des dossiers de subventions collectives (MaPrimeRénov' Copropriété, Éco-rénovons Paris), et accompagnement dans le choix de solutions adaptées aux contraintes architecturales parisiennes (isolation par l'intérieur, remplacement des fenêtres respectant les normes ABF). Nous assurons également le suivi des consommations post-travaux et la valorisation du gain énergétique dans la valeur patrimoniale de l'immeuble. Notre expertise des spécificités du bâti parisien nous permet de concilier performance énergétique et préservation du patrimoine.",
      category: "syndic",
    },
    {
      id: "q25",
      question:
        "Quelles sont les particularités de la gestion locative pour un bien en défiscalisation Pinel à Paris ?",
      answer:
        "La gestion d'un bien en défiscalisation Pinel à Paris requiert une attention particulière : respect strict du plafond de loyer Pinel selon la zone (A bis pour Paris), vérification rigoureuse des conditions de ressources des locataires avec conservation des justificatifs, établissement d'un bail conforme aux exigences du dispositif (engagement de location de 6, 9 ou 12 ans), déclaration annuelle spécifique pour le maintien de l'avantage fiscal, et suivi des évolutions législatives pouvant impacter le dispositif. Nous fournissons un reporting fiscal annuel détaillé facilitant votre déclaration d'impôts et veillons à la continuité locative pour éviter toute rupture préjudiciable à votre avantage fiscal. Notre expertise en défiscalisation immobilière vous garantit une sécurisation maximale de votre investissement Pinel dans le respect des contraintes légales.",
      category: "gestion",
    },
    {
      id: "q26",
      question: "Comment DOGES accompagne-t-il les propriétaires dans la rénovation d'un bien avant mise en location ?",
      answer:
        "Notre accompagnement pour la rénovation avant mise en location comprend : une étude de marché précise pour déterminer le positionnement optimal du bien et le budget de rénovation pertinent, la définition d'un cahier des charges adapté aux attentes du marché locatif local, la sélection d'artisans qualifiés avec mise en concurrence, le suivi hebdomadaire du chantier avec reportage photos, la coordination des différents corps de métier, et la réception des travaux avec levée des réserves. Nous conseillons également sur les choix de matériaux et d'équipements offrant le meilleur rapport qualité/prix/durabilité pour une location, et pouvons avancer les frais de travaux pour les clients en gestion complète. Notre objectif est d'optimiser votre investissement pour maximiser le rendement locatif tout en valorisant votre patrimoine sur le long terme.",
      category: "gestion",
    },
    {
      id: "q27",
      question: "Quelles sont les spécificités de la gestion d'une SCI familiale par DOGES ?",
      answer:
        "Notre gestion des SCI familiales comprend plusieurs volets : tenue des assemblées générales annuelles avec rédaction des procès-verbaux conformes, gestion administrative complète (déclarations fiscales 2072, suivi des comptes courants d'associés), optimisation de la stratégie patrimoniale en fonction des objectifs familiaux (transmission, démembrement), conseil sur la fiscalité spécifique des SCI (IR ou IS), et coordination avec votre notaire et expert-comptable. Nous assurons également la médiation en cas de désaccord entre associés et proposons des solutions d'arbitrage pour les décisions stratégiques. Notre expertise juridique et fiscale des sociétés civiles immobilières vous permet de bénéficier pleinement des avantages de cette structure tout en sécurisant la gestion de votre patrimoine familial sur plusieurs générations.",
      category: "gestion",
    },
    {
      id: "q28",
      question: "Comment DOGES gère-t-il les locations meublées professionnelles (LMP) ?",
      answer:
        "Notre gestion des locations meublées professionnelles (LMP) s'articule autour de plusieurs services spécifiques : vérification de la conformité du mobilier avec la liste réglementaire des équipements obligatoires, optimisation fiscale adaptée au statut LMP (amortissements, charges déductibles), tenue d'une comptabilité commerciale conforme aux obligations BIC, déclaration de TVA si applicable, et conseil sur l'évolution du statut (seuils de recettes, prédominance des recettes locatives). Nous assurons également un suivi de l'occupation pour maintenir un taux élevé de remplissage, une gestion des contrats courts avec rotations fréquentes, et un entretien régulier du mobilier et des équipements. Notre expertise du marché parisien de la location meublée vous permet de maximiser la rentabilité de votre investissement tout en respectant les contraintes réglementaires spécifiques au statut LMP.",
      category: "gestion",
    },
    {
      id: "q29",
      question: "Quelles garanties DOGES offre-t-il en cas de dégradations importantes causées par un locataire ?",
      answer:
        "En cas de dégradations importantes causées par un locataire, notre protection est multiple : mobilisation immédiate du dépôt de garantie avec justification détaillée, activation de la garantie dégradations immobilières si souscrite (jusqu'à 10 000€ de couverture), constitution d'un dossier de preuve solide avec constat d'huissier si nécessaire, mise en œuvre des procédures de recouvrement auprès du locataire défaillant, et accompagnement juridique complet en cas de contentieux. Pour les dégradations dépassant le cadre assurantiel, nous coordonnons les travaux de remise en état avec nos artisans partenaires à tarifs négociés et pouvons avancer les frais pour accélérer la relocation. Notre service contentieux dédié assure un suivi rigoureux de chaque dossier jusqu'à l'indemnisation complète du propriétaire, avec un taux de résolution amiable de 85% des litiges liés aux dégradations.",
      category: "gli",
    },
    {
      id: "q30",
      question:
        "Comment DOGES accompagne-t-il les propriétaires dans la mise aux normes PMR (Personnes à Mobilité Réduite) ?",
      answer:
        "Notre accompagnement pour la mise aux normes PMR comprend : réalisation d'un diagnostic d'accessibilité complet, identification des travaux prioritaires selon la réglementation en vigueur, élaboration d'un plan de mise en conformité progressive, recherche des aides financières disponibles (crédit d'impôt, subventions ANAH, aides des collectivités), et coordination avec les instances de copropriété pour les parties communes. Nous sélectionnons des entreprises spécialisées en accessibilité et supervisons les travaux selon les normes PMR (largeur des portes, suppression des seuils, adaptation des sanitaires, installation de rampes). Notre expertise technique vous permet de valoriser votre bien auprès d'une clientèle spécifique tout en respectant vos obligations légales, notamment pour les ERP (Établissements Recevant du Public) ou les logements situés en rez-de-chaussée particulièrement adaptés aux personnes à mobilité réduite.",
      category: "gestion",
    },
  ]

  // Filtrer les questions par catégorie et recherche
  const filteredFaqs = faqs.filter((faq) => {
    const matchesCategory = activeCategory === "all" || faq.category === activeCategory
    const matchesSearch =
      searchQuery === "" ||
      faq.question.toLowerCase().includes(searchQuery.toLowerCase()) ||
      faq.answer.toLowerCase().includes(searchQuery.toLowerCase())
    return matchesCategory && matchesSearch
  })

  // Toggle l'état ouvert/fermé d'une question
  const toggleQuestion = (id: string) => {
    setOpenQuestions((prev) => ({
      ...prev,
      [id]: !prev[id],
    }))
  }

  return (
    <>
      <PageHeader
        title="Questions Fréquentes"
        description="Trouvez rapidement des réponses à vos questions sur nos services"
        breadcrumbs={[{ label: "FAQ", href: "/faq" }]}
        backgroundImage="/customer-service-team.png"
      >
        <script
          type="application/ld+json"
          dangerouslySetInnerHTML={{
            __html: JSON.stringify({
              "@context": "https://schema.org",
              "@type": "FAQPage",
              mainEntity: [
                {
                  "@type": "Question",
                  name: "Quels sont les services proposés par DOGES ?",
                  acceptedAnswer: {
                    "@type": "Answer",
                    text: "DOGES propose une gamme complète de services immobiliers : gestion locative, syndic de copropriété, transactions immobilières, garantie loyers impayés et assurance PNO. Notre équipe d'experts vous accompagne dans tous vos projets immobiliers avec des solutions personnalisées.",
                  },
                },
                {
                  "@type": "Question",
                  name: "Quels sont les tarifs de la gestion locative ?",
                  acceptedAnswer: {
                    "@type": "Answer",
                    text: "Nos honoraires de gestion locative débutent à 6% HT des loyers encaissés pour notre formule Essentiel. Nous proposons également des formules Confort (8% HT) et Sérénité (10% HT) avec des services supplémentaires. Contactez-nous pour un devis personnalisé adapté à vos besoins.",
                  },
                },
                {
                  "@type": "Question",
                  name: "Comment fonctionne la garantie loyers impayés ?",
                  acceptedAnswer: {
                    "@type": "Answer",
                    text: "Notre garantie loyers impayés (GLI) vous protège contre les impayés de loyer, les dégradations locatives et prend en charge les frais de procédure. Elle couvre jusqu'à 24 mois de loyers impayés et jusqu'à 10 000€ de dégradations. Le coût varie entre 2,5% et 3,5% du montant annuel des loyers et charges.",
                  },
                },
              ],
            }),
          }}
        />
      </PageHeader>

      {/* Recherche et filtres */}
      <section className="py-8 bg-gray-50">
        <div className="container mx-auto px-4">
          <div className="max-w-3xl mx-auto">
            <div className="relative mb-8">
              <Search className="absolute left-3 top-1/2 transform -translate-y-1/2 text-gray-400" />
              <input
                type="text"
                placeholder="Rechercher une question..."
                className="w-full pl-10 pr-4 py-3 rounded-lg border border-gray-300 focus:outline-none focus:ring-2 focus:ring-[#002395]"
                value={searchQuery}
                onChange={(e) => setSearchQuery(e.target.value)}
              />
            </div>

            <div className="flex flex-wrap gap-2">
              {faqCategories.map((category) => (
                <button
                  key={category.id}
                  className={`px-4 py-2 rounded-full text-sm font-medium transition-colors ${
                    activeCategory === category.id
                      ? "bg-[#002395] text-white"
                      : "bg-white text-gray-700 hover:bg-gray-100"
                  }`}
                  onClick={() => setActiveCategory(category.id)}
                >
                  {category.name}
                </button>
              ))}
            </div>
          </div>
        </div>
      </section>

      {/* Questions les plus fréquentes */}
      <section className="py-8">
        <div className="container mx-auto px-4">
          <div className="max-w-3xl mx-auto">
            <h2 className="text-xl font-semibold mb-4 text-center">Questions les plus fréquentes</h2>
            <div className="grid grid-cols-1 md:grid-cols-2 gap-4">
              {faqs.slice(0, 6).map((faq) => (
                <div
                  key={`popular-${faq.id}`}
                  className="bg-white rounded-lg p-4 shadow-sm border border-gray-100 hover:shadow-md transition-shadow"
                  onClick={() => toggleQuestion(faq.id)}
                >
                  <p className="font-medium text-[#002395]">{faq.question}</p>
                </div>
              ))}
            </div>
          </div>
        </div>
      </section>

      {/* Questions et réponses */}
      <section className="py-12">
        <div className="container mx-auto px-4">
          <div className="max-w-3xl mx-auto">
            {filteredFaqs.length > 0 ? (
              <div className="space-y-6">
                {filteredFaqs.map((faq) => (
                  <div key={faq.id} className="bg-white rounded-xl shadow-sm overflow-hidden border border-gray-100">
                    <button
                      className="w-full text-left px-6 py-4 flex justify-between items-center focus:outline-none"
                      onClick={() => toggleQuestion(faq.id)}
                    >
                      <h3 className="text-lg font-semibold">{faq.question}</h3>
                      {openQuestions[faq.id] ? (
                        <ChevronUp className="h-5 w-5 text-[#002395]" />
                      ) : (
                        <ChevronDown className="h-5 w-5 text-[#002395]" />
                      )}
                    </button>
                    {openQuestions[faq.id] && (
                      <div className="px-6 pb-4">
                        <p className="text-gray-700">{faq.answer}</p>
                      </div>
                    )}
                  </div>
                ))}
              </div>
            ) : (
              <div className="text-center py-12">
                <p className="text-lg text-gray-600">Aucune question ne correspond à votre recherche.</p>
                <p className="mt-2 text-gray-500">Essayez avec d'autres termes ou catégories.</p>
              </div>
            )}
          </div>
        </div>
      </section>

      {/* Vous n'avez pas trouvé votre réponse ? */}
      <section className="py-12 bg-gray-50">
        <div className="container mx-auto px-4 text-center">
          <h2 className="text-2xl font-bold mb-6">Vous n'avez pas trouvé votre réponse ?</h2>
          <p className="text-lg text-gray-700 mb-8 max-w-2xl mx-auto">
            Notre équipe est à votre disposition pour répondre à toutes vos questions. N'hésitez pas à nous contacter.
          </p>
          <div className="flex flex-col sm:flex-row justify-center gap-4">
            <Link href="/contact">
              <Button className="bg-gradient-to-r from-[#002395] to-[#001875] text-white">
                Nous contacter
                <ArrowRight className="ml-2 h-4 w-4" />
              </Button>
            </Link>
            <Link href="/contact">
              <Button variant="outline" className="border-[#002395] text-[#002395] hover:bg-[#002395] hover:text-white">
                Demander un devis
              </Button>
            </Link>
          </div>
        </div>
      </section>
    </>
  )
}
