"use client"

import { useEffect } from "react"
import { useRouter } from "next/navigation"

export default function RedirectHautsDeSeine() {
  const router = useRouter()

  useEffect(() => {
    // Utilisation d'un timeout pour s'assurer que le code s'exécute après le rendu
    const timer = setTimeout(() => {
      // Redirection forcée avec window.location pour contourner le routeur Next.js
      window.location.href = "/services/administrateur-biens-hauts-de-seine"
    }, 100)

    return () => clearTimeout(timer)
  }, [router])

  return (
    <div className="min-h-screen flex flex-col items-center justify-center p-4">
      <h1 className="text-2xl font-bold mb-4">Redirection en cours...</h1>
      <p className="mb-6">Vous allez être redirigé vers la page Administrateur de biens Hauts-de-Seine.</p>
      <div className="w-16 h-16 border-t-4 border-blue-500 border-solid rounded-full animate-spin"></div>
      <p className="mt-8">
        Si la redirection ne fonctionne pas,{" "}
        <a
          href="/services/administrateur-biens-hauts-de-seine"
          className="text-blue-600 underline"
          onClick={(e) => {
            e.preventDefault()
            window.location.href = "/services/administrateur-biens-hauts-de-seine"
          }}
        >
          cliquez ici
        </a>
      </p>
    </div>
  )
}
