"use client"

import ServicePageLayout from "@/components/service-page-layout"
import FeeCalculator from "@/components/fee-calculator"

const AdministrateurBiensIleDefranceClientPage = () => {
  const tableOfContents = [
    { id: "expertise-locale", title: "Notre expertise locale en Île-de-France" },
    { id: "services-complets", title: "Services complets d'administration" },
    { id: "gestion-patrimoniale", title: "Gestion patrimoniale personnalisée" },
    { id: "avantages-doges", title: "Les avantages DOGES" },
    { id: "zones-intervention", title: "Nos zones d'intervention" },
    { id: "contact", title: "Nous contacter" },
  ]

  const relatedServices = [
    {
      title: "Gestion Locative Île-de-France",
      description: "Service de gestion locative dans toute la région",
      link: "/services/gestion-locative-ile-de-france",
    },
    {
      title: "Administrateur de Biens Paris",
      description: "Expertise spécialisée pour Paris",
      link: "/services/administrateur-biens-paris",
    },
    {
      title: "Syndic de Copropriété",
      description: "Gestion de copropriétés en Île-de-France",
      link: "/services/syndic-copropriete-paris",
    },
  ]

  const breadcrumbItems = [
    { name: "Accueil", url: "/" },
    { name: "Services", url: "/services" },
    { name: "Administrateur de Biens Île-de-France", url: "" },
  ]

  return (
    <ServicePageLayout
      title="Administrateur de Biens en Île-de-France"
      description="Expertise locale et gestion patrimoniale personnalisée dans toute la région parisienne"
      breadcrumbItems={breadcrumbItems}
      tableOfContentsItems={tableOfContents}
      headerImage="/placeholder.svg?height=400&width=800"
      relatedServices={relatedServices}
      calculatorComponent={<FeeCalculator />}
      ctaProps={{
        title: "Confiez-nous votre patrimoine en Île-de-France",
        description: "Bénéficiez de notre expertise locale pour optimiser la gestion de vos biens immobiliers.",
        buttonText: "Demander un devis",
        buttonLink: "/contact",
      }}
    >
      <div className="prose prose-lg max-w-none">
        <section id="expertise-locale" className="mb-12">
          <h2 className="text-3xl font-bold mb-6">Notre expertise locale en Île-de-France</h2>
          <p className="text-lg text-gray-700 mb-6">
            En tant qu'administrateur de biens spécialisé en Île-de-France, DOGES met à votre service une connaissance
            approfondie du marché immobilier francilien. Notre équipe maîtrise les spécificités de chaque département et
            commune de la région parisienne.
          </p>
          <div className="grid grid-cols-1 md:grid-cols-2 gap-6 mb-8">
            <div className="bg-blue-50 p-6 rounded-lg">
              <h3 className="text-xl font-semibold mb-3 text-blue-900">Connaissance du marché</h3>
              <p className="text-gray-700">
                Expertise des prix, tendances et réglementations locales dans tous les départements franciliens.
              </p>
            </div>
            <div className="bg-blue-50 p-6 rounded-lg">
              <h3 className="text-xl font-semibold mb-3 text-blue-900">Réseau professionnel</h3>
              <p className="text-gray-700">
                Partenaires locaux qualifiés : artisans, notaires, experts, assureurs dans toute la région.
              </p>
            </div>
          </div>
        </section>

        <section id="services-complets" className="mb-12">
          <h2 className="text-3xl font-bold mb-6">Services complets d'administration</h2>
          <p className="text-lg text-gray-700 mb-6">
            Notre service d'administration de biens en Île-de-France couvre tous les aspects de la gestion immobilière,
            de la location à la maintenance, en passant par la gestion financière et juridique.
          </p>
          <div className="space-y-6">
            <div className="border-l-4 border-blue-500 pl-6">
              <h3 className="text-xl font-semibold mb-2">Gestion locative complète</h3>
              <p className="text-gray-700">
                Recherche de locataires, rédaction des baux, encaissement des loyers, gestion des charges.
              </p>
            </div>
            <div className="border-l-4 border-blue-500 pl-6">
              <h3 className="text-xl font-semibold mb-2">Maintenance et travaux</h3>
              <p className="text-gray-700">
                Coordination des interventions, suivi des travaux, gestion des urgences 24h/24.
              </p>
            </div>
            <div className="border-l-4 border-blue-500 pl-6">
              <h3 className="text-xl font-semibold mb-2">Gestion administrative</h3>
              <p className="text-gray-700">
                Déclarations fiscales, comptabilité, assurances, conformité réglementaire.
              </p>
            </div>
          </div>
        </section>

        <section id="gestion-patrimoniale" className="mb-12">
          <h2 className="text-3xl font-bold mb-6">Gestion patrimoniale personnalisée</h2>
          <p className="text-lg text-gray-700 mb-6">
            Au-delà de la simple gestion locative, nous vous accompagnons dans l'optimisation et le développement de
            votre patrimoine immobilier en Île-de-France.
          </p>
          <div className="bg-gray-50 p-6 rounded-lg mb-6">
            <h3 className="text-xl font-semibold mb-4">Nos conseils patrimoniaux</h3>
            <ul className="space-y-2 text-gray-700">
              <li className="flex items-start">
                <span className="text-blue-500 mr-2">•</span>
                Optimisation fiscale et choix du régime adapté
              </li>
              <li className="flex items-start">
                <span className="text-blue-500 mr-2">•</span>
                Stratégies d'investissement et d'acquisition
              </li>
              <li className="flex items-start">
                <span className="text-blue-500 mr-2">•</span>
                Valorisation du patrimoine existant
              </li>
              <li className="flex items-start">
                <span className="text-blue-500 mr-2">•</span>
                Transmission et succession
              </li>
            </ul>
          </div>
        </section>

        <section id="avantages-doges" className="mb-12">
          <h2 className="text-3xl font-bold mb-6">Les avantages DOGES</h2>
          <div className="grid grid-cols-1 md:grid-cols-2 gap-6">
            <div className="bg-white border border-gray-200 p-6 rounded-lg shadow-sm">
              <h3 className="text-lg font-semibold mb-3">Proximité et réactivité</h3>
              <p className="text-gray-700">
                Équipes locales dans toute l'Île-de-France pour une gestion de proximité efficace.
              </p>
            </div>
            <div className="bg-white border border-gray-200 p-6 rounded-lg shadow-sm">
              <h3 className="text-lg font-semibold mb-3">Technologie avancée</h3>
              <p className="text-gray-700">Plateforme digitale pour suivre votre patrimoine en temps réel.</p>
            </div>
            <div className="bg-white border border-gray-200 p-6 rounded-lg shadow-sm">
              <h3 className="text-lg font-semibold mb-3">Transparence totale</h3>
              <p className="text-gray-700">Reporting détaillé et accès permanent à vos données patrimoniales.</p>
            </div>
            <div className="bg-white border border-gray-200 p-6 rounded-lg shadow-sm">
              <h3 className="text-lg font-semibold mb-3">Tarifs compétitifs</h3>
              <p className="text-gray-700">Honoraires transparents et adaptés à vos besoins spécifiques.</p>
            </div>
          </div>
        </section>

        <section id="zones-intervention" className="mb-12">
          <h2 className="text-3xl font-bold mb-6">Nos zones d'intervention</h2>
          <p className="text-lg text-gray-700 mb-6">
            DOGES intervient dans tous les départements de l'Île-de-France avec une expertise particulière dans les
            zones à fort potentiel immobilier.
          </p>
          <div className="grid grid-cols-2 md:grid-cols-4 gap-4">
            <div className="text-center p-4 bg-blue-50 rounded-lg">
              <div className="text-2xl font-bold text-blue-600">75</div>
              <div className="text-sm text-gray-700">Paris</div>
            </div>
            <div className="text-center p-4 bg-blue-50 rounded-lg">
              <div className="text-2xl font-bold text-blue-600">92</div>
              <div className="text-sm text-gray-700">Hauts-de-Seine</div>
            </div>
            <div className="text-center p-4 bg-blue-50 rounded-lg">
              <div className="text-2xl font-bold text-blue-600">93</div>
              <div className="text-sm text-gray-700">Seine-Saint-Denis</div>
            </div>
            <div className="text-center p-4 bg-blue-50 rounded-lg">
              <div className="text-2xl font-bold text-blue-600">94</div>
              <div className="text-sm text-gray-700">Val-de-Marne</div>
            </div>
            <div className="text-center p-4 bg-blue-50 rounded-lg">
              <div className="text-2xl font-bold text-blue-600">95</div>
              <div className="text-sm text-gray-700">Val-d'Oise</div>
            </div>
            <div className="text-center p-4 bg-blue-50 rounded-lg">
              <div className="text-2xl font-bold text-blue-600">78</div>
              <div className="text-sm text-gray-700">Yvelines</div>
            </div>
            <div className="text-center p-4 bg-blue-50 rounded-lg">
              <div className="text-2xl font-bold text-blue-600">91</div>
              <div className="text-sm text-gray-700">Essonne</div>
            </div>
            <div className="text-center p-4 bg-blue-50 rounded-lg">
              <div className="text-2xl font-bold text-blue-600">77</div>
              <div className="text-sm text-gray-700">Seine-et-Marne</div>
            </div>
          </div>
        </section>
      </div>
    </ServicePageLayout>
  )
}

export default AdministrateurBiensIleDefranceClientPage
