import type { Metadata } from "next"
import AdministrateurBiensIleDefranceClientPage from "./AdministrateurBiensIleDefranceClientPage"
import ServiceHeader from "@/components/service-header"

export const metadata: Metadata = {
  title: "Administrateur de biens en Île-de-France | DOGES",
  description:
    "Services d'administration de biens immobiliers dans toute l'Île-de-France. Gestion locative, syndic de copropriété et conseil patrimonial par des experts locaux.",
  keywords:
    "administrateur de biens Île-de-France, gestion immobilière IDF, syndic copropriété banlieue parisienne, gestionnaire patrimonial 92 94 78 95 91 77 93, DOGES",
}

export default function AdministrateurBiensIleDeFrancePage() {
  return (
    <>
      <ServiceHeader
        title="Administrateur de biens en Île-de-France"
        description="Services d'administration de biens immobiliers dans toute l'Île-de-France. Gestion locative, syndic de copropriété et conseil patrimonial par des experts locaux."
        breadcrumbItems={[
          { name: "Accueil", url: "/" },
          { name: "Services", url: "/services" },
          { name: "Administrateur de biens IDF", url: "/services/administrateur-biens-ile-de-france" },
        ]}
        backgroundImage="/administrateur-biens-ile-de-france.png"
      />
      <AdministrateurBiensIleDefranceClientPage />
    </>
  )
}
