import Image from "next/image"

const AdministrateurBiensPage = () => {
  return (
    <div className="container mx-auto py-12">
      <h1 className="text-3xl font-bold text-gray-800 mb-6">Administrateur de Biens à Paris 11, 12 et 20</h1>

      <div className="grid grid-cols-1 md:grid-cols-2 gap-8">
        {/* Left Column: Text Content */}
        <div>
          <p className="text-gray-700 mb-4">
            Vous êtes propriétaire d'un bien immobilier situé dans les 11ème, 12ème ou 20ème arrondissements de Paris et
            vous recherchez un administrateur de biens de confiance ? Notre agence immobilière est spécialisée dans la
            gestion locative et l'administration de biens dans ces secteurs prisés de la capitale.
          </p>
          <p className="text-gray-700 mb-4">
            Nous offrons une gamme complète de services pour simplifier la gestion de votre patrimoine immobilier :
            recherche de locataires solvables, rédaction de baux, gestion des loyers et des charges, suivi des travaux,
            assistance juridique et administrative, etc.
          </p>
          <p className="text-gray-700 mb-4">
            Notre connaissance approfondie du marché immobilier local nous permet de vous conseiller au mieux et
            d'optimiser la rentabilité de votre investissement. Nous sommes à votre écoute pour comprendre vos besoins
            et vous proposer une solution personnalisée.
          </p>
          <p className="text-gray-700 mb-4">
            Contactez-nous dès aujourd'hui pour discuter de vos projets et découvrir comment nous pouvons vous aider à
            gérer votre bien en toute sérénité.
          </p>
        </div>

        {/* Right Column: Image */}
        <div>
          <Image
            src="https://images.unsplash.com/photo-1582407947304-fd86f0244149?ixlib=rb-4.0.3&ixid=MnwxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8&auto=format&fit=crop&w=2070&q=80" // Replace with a relevant Unsplash image URL
            alt="Appartement Parisien"
            width={600}
            height={400}
            className="rounded-lg shadow-md"
            style={{
              maxWidth: "100%",
              height: "auto",
            }}
          />
        </div>
      </div>

      {/* Additional Sections (Optional) */}
      <div className="mt-12">
        <h2 className="text-2xl font-bold text-gray-800 mb-4">Nos Services</h2>
        <ul className="list-disc list-inside text-gray-700">
          <li>Recherche de locataires</li>
          <li>Rédaction de baux</li>
          <li>Gestion des loyers et des charges</li>
          <li>Suivi des travaux</li>
          <li>Assistance juridique et administrative</li>
        </ul>
      </div>

      <div className="mt-12">
        <h2 className="text-2xl font-bold text-gray-800 mb-4">Contactez-nous</h2>
        <p className="text-gray-700">N'hésitez pas à nous contacter pour toute question ou demande de devis.</p>
        <p className="text-gray-700">Téléphone: 01 23 45 67 89</p>
        <p className="text-gray-700">Email: contact@example.com</p>
      </div>
    </div>
  )
}

export default AdministrateurBiensPage
