import Image from "next/image"

const AdministrateurBiensPage = () => {
  return (
    <div className="container mx-auto py-12">
      <h1 className="text-3xl font-bold text-center mb-8">Administrateur de Biens à Paris 13, 14 et 15</h1>

      <div className="grid grid-cols-1 md:grid-cols-2 gap-8">
        {/* Left Column: Text Content */}
        <div>
          <p className="text-gray-700 mb-4">
            Vous êtes propriétaire d'un bien immobilier situé dans les arrondissements dynamiques de Paris 13, 14 ou 15
            ? Vous recherchez une gestion locative fiable et transparente ? Notre agence immobilière est spécialisée
            dans l'administration de biens et vous propose un service personnalisé pour optimiser la rentabilité de
            votre investissement.
          </p>
          <p className="text-gray-700 mb-4">
            Nous prenons en charge toutes les étapes de la gestion locative, de la recherche de locataires solvables à
            la perception des loyers, en passant par la gestion des travaux et des sinistres. Notre objectif est de vous
            libérer des contraintes liées à la gestion de votre bien tout en vous assurant un revenu régulier et
            sécurisé.
          </p>
          <p className="text-gray-700 mb-4">
            Nos experts connaissent parfaitement le marché immobilier parisien et vous conseillent sur la valorisation
            de votre bien et les meilleures stratégies à adopter pour maximiser vos revenus locatifs. Nous vous tenons
            informé de l'évolution de la législation et des obligations réglementaires en matière de location.
          </p>
          <p className="text-gray-700 mb-4">
            Contactez-nous dès aujourd'hui pour une étude personnalisée de vos besoins et découvrez comment nous pouvons
            vous aider à gérer votre bien immobilier en toute sérénité.
          </p>
        </div>

        {/* Right Column: Image */}
        <div>
          <Image
            src="https://images.unsplash.com/photo-1582407947304-6996c363e5a7?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=2069&q=80" // Replace with a relevant Unsplash image URL
            alt="Appartement Parisien"
            width={600}
            height={400}
            className="rounded-lg shadow-md"
            style={{
              maxWidth: "100%",
              height: "auto",
            }}
          />
        </div>
      </div>

      {/* Additional Sections (Optional) */}
      <div className="mt-12">
        <h2 className="text-2xl font-bold text-center mb-4">Nos Services</h2>
        <ul className="list-disc list-inside text-gray-700">
          <li>Recherche de locataires</li>
          <li>Rédaction des baux</li>
          <li>Gestion des états des lieux</li>
          <li>Encaissement des loyers</li>
          <li>Gestion des impayés</li>
          <li>Suivi des travaux</li>
          <li>Gestion des sinistres</li>
          <li>Reporting régulier</li>
        </ul>
      </div>

      <div className="mt-12">
        <h2 className="text-2xl font-bold text-center mb-4">Contactez-nous</h2>
        <p className="text-gray-700 text-center">
          N'hésitez pas à nous contacter pour toute question ou demande de devis.
        </p>
        <div className="flex justify-center mt-4">
          <a href="/contact" className="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded">
            Contact
          </a>
        </div>
      </div>
    </div>
  )
}

export default AdministrateurBiensPage
