import type { Metadata } from "next"
import Link from "next/link"
import ServiceHeader from "@/components/service-header"

export const metadata: Metadata = {
  title: "Administrateur de Biens Paris 19e Arrondissement | DOGES",
  description:
    "Services d'administration de biens immobiliers dans le 19e arrondissement de Paris. Gestion locative, syndic et transaction par des experts locaux.",
  alternates: {
    canonical: "https://www.doges.fr/services/administrateur-biens-paris-19",
  },
}

export default function AdministrateurBiensParis19Page() {
  return (
    <div className="min-h-screen bg-gray-50">
      <ServiceHeader
        title="Administrateur de Biens Paris 19e Arrondissement"
        description="Services d'administration de biens immobiliers dans un quartier en pleine mutation"
        breadcrumbItems={[
          { name: "Accueil", url: "/" },
          { name: "Services", url: "/services" },
          { name: "Administrateur de Biens Paris 19", url: "/services/administrateur-biens-paris-19" },
        ]}
        backgroundImage="https://images.unsplash.com/photo-1502602898536-47ad22581b52?q=80&w=2073&auto=format&fit=crop"
      />

      {/* Main Content */}
      <div className="container mx-auto px-4 py-12">
        <div className="grid grid-cols-1 lg:grid-cols-3 gap-8">
          {/* Main Content */}
          <div className="lg:col-span-2">
            <section className="mb-12">
              <h2 className="text-2xl font-bold text-[#002395] mb-6">
                Le 19e arrondissement : un secteur dynamique et prometteur
              </h2>

              <div className="bg-white p-6 rounded-lg shadow-md mb-8">
                <h3 className="text-xl font-semibold mb-3 text-[#002395]">Un quartier en pleine transformation</h3>
                <p className="text-gray-600 mb-4">
                  <strong>Buttes-Chaumont, Villette, Bassin de la Villette</strong>
                </p>
                <p className="text-gray-600 mb-4">
                  Le 19e arrondissement de Paris connaît une transformation remarquable depuis plusieurs années.
                  Autrefois quartier populaire et industriel, il est aujourd'hui l'un des secteurs les plus dynamiques
                  de la capitale, attirant une population jeune et créative.
                </p>
                <p className="text-gray-600">
                  Avec ses espaces verts emblématiques comme le parc des Buttes-Chaumont, ses équipements culturels
                  comme la Cité des Sciences et le Zénith, et son canal de l'Ourcq réaménagé, le 19e offre un cadre de
                  vie attractif et un potentiel d'investissement intéressant.
                </p>
              </div>

              <div className="bg-white p-6 rounded-lg shadow-md mb-8">
                <h3 className="text-xl font-semibold mb-3 text-[#002395]">Un marché immobilier en évolution</h3>
                <p className="text-gray-600 mb-4">
                  Le marché immobilier du 19e arrondissement présente plusieurs avantages :
                </p>
                <ul className="list-disc pl-6 space-y-2 text-gray-600">
                  <li>Des prix au m² plus accessibles que dans le centre de Paris</li>
                  <li>Une forte demande locative, notamment de la part des jeunes actifs et des familles</li>
                  <li>Un potentiel de valorisation important grâce aux projets urbains en cours</li>
                  <li>Une diversité de biens, des immeubles haussmanniens aux constructions contemporaines</li>
                  <li>Une excellente desserte en transports en commun (lignes 2, 5, 7, 7bis et tramway)</li>
                </ul>
              </div>
            </section>

            {/* Reste du contenu... */}
          </div>

          {/* Sidebar */}
          <div className="lg:col-span-1">
            <div className="sticky top-8 space-y-6">
              <div className="bg-white p-6 rounded-lg shadow-md">
                <h3 className="text-lg font-semibold mb-4 text-[#002395]">Dans cette page</h3>
                <ul className="space-y-2 text-sm">
                  <li>
                    <a href="#le-19e-arrondissement" className="text-[#002395] hover:underline">
                      Le 19e arrondissement : un secteur dynamique
                    </a>
                  </li>
                  <li>
                    <a href="#nos-services" className="text-[#002395] hover:underline">
                      Nos services dans le 19e arrondissement
                    </a>
                  </li>
                  <li>
                    <a href="#expertise-locale" className="text-[#002395] hover:underline">
                      Notre expertise locale
                    </a>
                  </li>
                  <li>
                    <a href="#faq" className="text-[#002395] hover:underline">
                      Questions fréquentes
                    </a>
                  </li>
                </ul>
              </div>

              <div className="bg-white p-6 rounded-lg shadow-md">
                <h3 className="text-lg font-semibold mb-4 text-[#002395]">Besoin d'aide ?</h3>
                <p className="mb-4 text-gray-600">
                  Nos experts du 19e arrondissement sont à votre disposition pour répondre à toutes vos questions.
                </p>
                <Link
                  href="/contact"
                  className="block w-full py-3 px-4 bg-[#002395] text-white text-center rounded-md hover:bg-blue-800 transition-colors"
                >
                  Nous contacter
                </Link>
              </div>

              <div className="bg-white p-6 rounded-lg shadow-md">
                <h3 className="text-lg font-semibold mb-4 text-[#002395]">Services associés</h3>
                <ul className="space-y-3">
                  <li>
                    <Link href="/services/administrateur-biens-paris" className="text-[#002395] hover:underline">
                      Administrateur de biens Paris
                    </Link>
                  </li>
                  <li>
                    <Link href="/services/administrateur-biens-paris-5-6-7" className="text-[#002395] hover:underline">
                      Administrateur de biens Paris 5-6-7
                    </Link>
                  </li>
                  <li>
                    <Link
                      href="/services/administrateur-biens-paris-13-14-15"
                      className="text-[#002395] hover:underline"
                    >
                      Administrateur de biens Paris 13-14-15
                    </Link>
                  </li>
                  <li>
                    <Link href="/services/gestion-locative-paris" className="text-[#002395] hover:underline">
                      Gestion locative Paris
                    </Link>
                  </li>
                </ul>
              </div>
            </div>
          </div>
        </div>

        {/* CTA Section */}
        <section className="mt-16 text-center">
          <div className="bg-[#002395] text-white p-8 rounded-lg">
            <h2 className="text-2xl font-bold mb-4">Vous possédez un bien dans le 19e arrondissement ?</h2>
            <p className="mb-6 text-lg">
              Bénéficiez de notre expertise locale pour optimiser la gestion et la rentabilité de votre patrimoine
              immobilier.
            </p>
            <div className="flex flex-col sm:flex-row gap-4 justify-center">
              <Link
                href="/contact"
                className="bg-white text-[#002395] px-8 py-3 rounded-lg font-semibold hover:bg-gray-100 transition-colors"
              >
                Demander un devis
              </Link>
              <Link
                href="/services/transaction"
                className="border-2 border-white text-white px-8 py-3 rounded-lg font-semibold hover:bg-white hover:text-[#002395] transition-colors"
              >
                Estimation gratuite
              </Link>
            </div>
          </div>
        </section>
      </div>
    </div>
  )
}
