"use client"

export default function Error({
  error,
  reset,
}: {
  error: Error & { digest?: string }
  reset: () => void
}) {
  return (
    <div className="min-h-screen bg-gray-50 flex items-center justify-center">
      <div className="text-center">
        <h2 className="text-2xl font-bold text-gray-900 mb-4">Une erreur est survenue</h2>
        <p className="text-gray-600 mb-6">Impossible de charger la page administrateur de biens Paris 8-16-17.</p>
        <button
          onClick={() => reset()}
          className="bg-[#002395] text-white px-6 py-3 rounded-lg hover:bg-blue-800 transition-colors"
        >
          Réessayer
        </button>
      </div>
    </div>
  )
}
