import Link from "next/link"

export default function NotFound() {
  return (
    <div className="min-h-screen bg-gray-50 flex items-center justify-center">
      <div className="text-center">
        <h2 className="text-2xl font-bold text-gray-900 mb-4">Page non trouvée</h2>
        <p className="text-gray-600 mb-6">La page administrateur de biens Paris 9-10-18 n'existe pas.</p>
        <Link
          href="/services"
          className="bg-[#002395] text-white px-6 py-3 rounded-lg hover:bg-blue-800 transition-colors"
        >
          Retour aux services
        </Link>
      </div>
    </div>
  )
}
