import type { Metadata } from "next"
import Link from "next/link"
import ServiceHeader from "@/components/service-header"

export const metadata: Metadata = {
  title: "Administrateur de Biens Paris Centre (1er, 2e, 3e, 4e) | DOGES",
  description:
    "Services d'administration de biens immobiliers dans le centre historique de Paris (1er, 2e, 3e, 4e arrondissements). Expertise des immeubles anciens et biens d'exception.",
  alternates: {
    canonical: "https://www.doges.fr/services/administrateur-biens-paris-centre",
  },
}

export default function AdministrateurBiensParisCentrePage() {
  return (
    <div className="min-h-screen bg-gray-50">
      <ServiceHeader
        title="Administrateur de Biens Paris Centre"
        description="Expertise des immeubles anciens et biens d'exception dans le cœur historique de Paris"
        breadcrumbItems={[
          { name: "Accueil", url: "/" },
          { name: "Services", url: "/services" },
          { name: "Administrateur de Biens Paris Centre", url: "/services/administrateur-biens-paris-centre" },
        ]}
        backgroundImage="https://images.unsplash.com/photo-1502602898536-47ad22581b52?q=80&w=2073&auto=format&fit=crop"
      />

      {/* Main Content */}
      <div className="container mx-auto px-4 py-12">
        <div className="grid grid-cols-1 lg:grid-cols-3 gap-8">
          {/* Main Content */}
          <div className="lg:col-span-2">
            <section className="mb-12">
              <h2 className="text-2xl font-bold text-[#002395] mb-6">
                Le cœur historique de Paris : 1er, 2e, 3e et 4e arrondissements
              </h2>

              <div className="bg-white p-6 rounded-lg shadow-md mb-8">
                <h3 className="text-xl font-semibold mb-3 text-[#002395]">Un patrimoine immobilier d'exception</h3>
                <p className="text-gray-600 mb-4">
                  <strong>Louvre, Châtelet, Marais, Île Saint-Louis</strong>
                </p>
                <p className="text-gray-600 mb-4">
                  Les 1er, 2e, 3e et 4e arrondissements constituent le cœur historique de Paris, abritant les monuments
                  les plus emblématiques de la capitale. Ces arrondissements offrent un patrimoine immobilier unique,
                  mêlant immeubles anciens de caractère, hôtels particuliers et appartements d'exception.
                </p>
                <p className="text-gray-600">
                  Du Louvre au Marais, en passant par l'Île Saint-Louis et les Halles, ces quartiers prestigieux
                  attirent une clientèle internationale exigeante, à la recherche de biens d'exception dans un cadre
                  historique préservé.
                </p>
              </div>

              <div className="bg-white p-6 rounded-lg shadow-md mb-8">
                <h3 className="text-xl font-semibold mb-3 text-[#002395]">Un marché immobilier de prestige</h3>
                <p className="text-gray-600 mb-4">
                  Le marché immobilier du centre de Paris présente des caractéristiques uniques :
                </p>
                <ul className="list-disc pl-6 space-y-2 text-gray-600">
                  <li>Prix au m² parmi les plus élevés de Paris et du monde</li>
                  <li>Demande internationale constante pour les biens d'exception</li>
                  <li>Patrimoine architectural protégé et réglementé</li>
                  <li>Rareté des biens disponibles à la vente ou à la location</li>
                  <li>Potentiel de valorisation stable et durable</li>
                  <li>Attractivité touristique et culturelle exceptionnelle</li>
                </ul>
              </div>
            </section>

            <section className="mb-12">
              <h2 className="text-2xl font-bold mb-6 text-[#002395]">Nos services spécialisés</h2>

              <div className="grid md:grid-cols-2 gap-6">
                <div className="bg-white p-6 rounded-lg shadow-md">
                  <h3 className="text-xl font-semibold mb-3 text-[#002395]">Gestion de biens d'exception</h3>
                  <ul className="list-disc pl-6 space-y-2 text-gray-600">
                    <li>Sélection rigoureuse de locataires de qualité</li>
                    <li>Gestion des biens meublés haut de gamme</li>
                    <li>Locations saisonnières et courte durée</li>
                    <li>Conciergerie et services personnalisés</li>
                    <li>Maintenance préventive et curative</li>
                    <li>Respect des contraintes patrimoniales</li>
                  </ul>
                </div>

                <div className="bg-white p-6 rounded-lg shadow-md">
                  <h3 className="text-xl font-semibold mb-3 text-[#002395]">Syndic spécialisé</h3>
                  <ul className="list-disc pl-6 space-y-2 text-gray-600">
                    <li>Gestion d'immeubles classés et protégés</li>
                    <li>Expertise des contraintes ABF</li>
                    <li>Travaux de restauration et rénovation</li>
                    <li>Relations avec les Monuments Historiques</li>
                    <li>Assemblées générales multilingues</li>
                    <li>Gestion de copropriétés de prestige</li>
                  </ul>
                </div>

                <div className="bg-white p-6 rounded-lg shadow-md">
                  <h3 className="text-xl font-semibold mb-3 text-[#002395]">Transaction de prestige</h3>
                  <ul className="list-disc pl-6 space-y-2 text-gray-600">
                    <li>Estimation d'appartements d'exception</li>
                    <li>Marketing international et discret</li>
                    <li>Réseau d'acquéreurs qualifiés</li>
                    <li>Négociation et sécurisation juridique</li>
                    <li>Accompagnement clientèle internationale</li>
                    <li>Conseil en investissement patrimonial</li>
                  </ul>
                </div>

                <div className="bg-white p-6 rounded-lg shadow-md">
                  <h3 className="text-xl font-semibold mb-3 text-[#002395]">Conseil patrimonial</h3>
                  <ul className="list-disc pl-6 space-y-2 text-gray-600">
                    <li>Optimisation fiscale internationale</li>
                    <li>Structuration patrimoniale complexe</li>
                    <li>Conseil en transmission</li>
                    <li>Valorisation de biens historiques</li>
                    <li>Montage d'investissements d'exception</li>
                    <li>Gestion de family offices</li>
                  </ul>
                </div>
              </div>
            </section>

            <section className="mb-12">
              <h2 className="text-2xl font-bold mb-6 text-[#002395]">Notre expertise des arrondissements centraux</h2>

              <div className="space-y-6">
                <div className="bg-white p-6 rounded-lg shadow-md">
                  <h3 className="text-xl font-semibold mb-3 text-[#002395]">1er arrondissement - Louvre</h3>
                  <p className="text-gray-600 mb-4">
                    Quartier emblématique abritant le Louvre, les Tuileries et la place Vendôme. Immeubles haussmanniens
                    et appartements de prestige avec vue sur les monuments.
                  </p>
                  <ul className="list-disc pl-6 space-y-1 text-gray-600">
                    <li>Appartements avec vue sur le Louvre et les Tuileries</li>
                    <li>Immeubles de standing rue de Rivoli</li>
                    <li>Lofts et ateliers d'artistes</li>
                    <li>Commerces de luxe et bureaux prestigieux</li>
                  </ul>
                </div>

                <div className="bg-white p-6 rounded-lg shadow-md">
                  <h3 className="text-xl font-semibold mb-3 text-[#002395]">2e arrondissement - Bourse</h3>
                  <p className="text-gray-600 mb-4">
                    Quartier d'affaires historique avec ses passages couverts et ses immeubles du XIXe siècle. Mélange
                    unique entre résidentiel et tertiaire.
                  </p>
                  <ul className="list-disc pl-6 space-y-1 text-gray-600">
                    <li>Appartements dans les passages historiques</li>
                    <li>Bureaux et commerces rue du Quatre-Septembre</li>
                    <li>Immeubles haussmanniens rénovés</li>
                    <li>Lofts et espaces atypiques</li>
                  </ul>
                </div>

                <div className="bg-white p-6 rounded-lg shadow-md">
                  <h3 className="text-xl font-semibold mb-3 text-[#002395]">3e arrondissement - Temple</h3>
                  <p className="text-gray-600 mb-4">
                    Partie nord du Marais avec ses hôtels particuliers et ses rues pavées. Quartier en pleine
                    gentrification attirant une clientèle branchée.
                  </p>
                  <ul className="list-disc pl-6 space-y-1 text-gray-600">
                    <li>Hôtels particuliers et appartements de charme</li>
                    <li>Lofts et ateliers d'artistes</li>
                    <li>Appartements avec cours et jardins</li>
                    <li>Commerces et galeries d'art</li>
                  </ul>
                </div>

                <div className="bg-white p-6 rounded-lg shadow-md">
                  <h3 className="text-xl font-semibold mb-3 text-[#002395]">4e arrondissement - Hôtel-de-Ville</h3>
                  <p className="text-gray-600 mb-4">
                    Cœur du Marais historique et Île Saint-Louis. Patrimoine architectural exceptionnel avec des biens
                    uniques au monde.
                  </p>
                  <ul className="list-disc pl-6 space-y-1 text-gray-600">
                    <li>Appartements sur l'Île Saint-Louis</li>
                    <li>Hôtels particuliers du Marais</li>
                    <li>Duplex et triplex d'exception</li>
                    <li>Appartements avec vue sur Notre-Dame</li>
                  </ul>
                </div>
              </div>
            </section>
          </div>

          {/* Sidebar */}
          <div className="lg:col-span-1">
            <div className="sticky top-8 space-y-6">
              <div className="bg-white p-6 rounded-lg shadow-md">
                <h3 className="text-lg font-semibold mb-4 text-[#002395]">Besoin d'aide ?</h3>
                <p className="mb-4 text-gray-600">
                  Nos experts du centre de Paris sont à votre disposition pour la gestion de vos biens d'exception.
                </p>
                <Link
                  href="/contact"
                  className="block w-full py-3 px-4 bg-[#002395] text-white text-center rounded-md hover:bg-blue-800 transition-colors"
                >
                  Nous contacter
                </Link>
              </div>

              <div className="bg-white p-6 rounded-lg shadow-md">
                <h3 className="text-lg font-semibold mb-4 text-[#002395]">Services associés</h3>
                <ul className="space-y-3">
                  <li>
                    <Link href="/services/administrateur-biens-paris" className="text-[#002395] hover:underline">
                      Administrateur de biens Paris
                    </Link>
                  </li>
                  <li>
                    <Link href="/services/administrateur-biens-paris-5-6-7" className="text-[#002395] hover:underline">
                      Administrateur de biens Paris 5-6-7
                    </Link>
                  </li>
                  <li>
                    <Link
                      href="/services/administrateur-biens-immeubles-haussmanniens"
                      className="text-[#002395] hover:underline"
                    >
                      Immeubles haussmanniens
                    </Link>
                  </li>
                  <li>
                    <Link href="/services/transaction" className="text-[#002395] hover:underline">
                      Transaction immobilière
                    </Link>
                  </li>
                </ul>
              </div>
            </div>
          </div>
        </div>

        {/* CTA Section */}
        <section className="mt-16 text-center">
          <div className="bg-[#002395] text-white p-8 rounded-lg">
            <h2 className="text-2xl font-bold mb-4">Vous possédez un bien d'exception dans le centre de Paris ?</h2>
            <p className="mb-6 text-lg">
              Bénéficiez de notre expertise spécialisée pour la gestion de votre patrimoine immobilier de prestige.
            </p>
            <div className="flex flex-col sm:flex-row gap-4 justify-center">
              <Link
                href="/contact"
                className="bg-white text-[#002395] px-8 py-3 rounded-lg font-semibold hover:bg-gray-100 transition-colors"
              >
                Demander un devis
              </Link>
              <Link
                href="/services/transaction"
                className="border-2 border-white text-white px-8 py-3 rounded-lg font-semibold hover:bg-white hover:text-[#002395] transition-colors"
              >
                Estimation gratuite
              </Link>
            </div>
          </div>
        </section>
      </div>
    </div>
  )
}
