"use client"

import { Check, ArrowRight, MapPin, Phone, Mail } from "lucide-react"
import { Button } from "@/components/ui/button"
import Link from "next/link"
import Image from "next/image"
import FeeCalculator from "@/components/fee-calculator"
import SidebarTableOfContents from "@/components/sidebar-table-of-contents"
import { ArrondissementLinks } from "./ArrondissementLinks"
import ServicesSidebarWidgets from "@/components/services-sidebar-widgets"
import { Breadcrumb } from "@/components/breadcrumb"

export default function GestionLocativeParisClient() {
  // Quartiers de Paris pour le SEO
  const parisDistricts = [
    "Paris 1er",
    "Paris 2ème",
    "Paris 3ème",
    "Paris 4ème",
    "Paris 5ème",
    "Paris 6ème",
    "Paris 7ème",
    "Paris 8ème",
    "Paris 9ème",
    "Paris 10ème",
    "Paris 11ème",
    "Paris 12ème",
    "Paris 13ème",
    "Paris 14ème",
    "Paris 15ème",
    "Paris 16ème",
    "Paris 17ème",
    "Paris 18ème",
    "Paris 19ème",
    "Paris 20ème",
  ]

  const tableOfContentsHeadings = [
    { id: "introduction", text: "Gestion locative professionnelle à Paris", level: 2 },
    { id: "zones", text: "Nos zones d'intervention à Paris", level: 2 },
    { id: "services", text: "Nos services de gestion locative à Paris", level: 2 },
    { id: "avantages", text: "Pourquoi choisir DOGES ?", level: 2 },
    { id: "tarifs", text: "Tarifs de gestion locative à Paris", level: 2 },
    { id: "calculateur", text: "Calculateur de frais de gestion", level: 2 },
    { id: "temoignages", text: "Témoignages de propriétaires", level: 2 },
    { id: "faq", text: "Questions fréquentes", level: 2 },
    { id: "contact", text: "Nous contacter", level: 2 },
  ]

  // Définir les éléments du fil d'Ariane
  const breadcrumbItems = [
    { name: "Services", url: "/services" },
    { name: "Gestion Locative", url: "/services/gestion-locative" },
    { name: "Paris", url: "/services/gestion-locative-paris" },
  ]

  return (
    <>
      {/* En-tête de page standardisée */}
      <div className="relative bg-[#002395] text-white">
        <div className="absolute inset-0 overflow-hidden">
          <Image
            src="/paris-property-management.png"
            alt="Gestion locative à Paris"
            fill
            className="object-cover opacity-20"
            priority
          />
        </div>
        <div className="container relative z-10 py-16 px-4">
          <div className="max-w-4xl">
            <Breadcrumb items={breadcrumbItems} className="text-white/70" />
            <h1 className="text-4xl md:text-5xl font-bold mb-4">Gestion Locative à Paris</h1>
            <p className="text-xl md:text-2xl font-light max-w-3xl">
              Confiez la gestion de votre bien immobilier parisien à des experts locaux
            </p>
          </div>
        </div>
      </div>

      <section className="py-16">
        <div className="container mx-auto px-4">
          <div className="grid lg:grid-cols-3 gap-12">
            {/* Contenu principal - 2/3 colonnes */}
            <div className="lg:col-span-2 space-y-12">
              {/* Widget de table des matières pour mobile */}
              <div className="lg:hidden mb-6">
                <SidebarTableOfContents headings={tableOfContentsHeadings} />
              </div>

              <div id="introduction">
                <h2 className="text-3xl font-bold mb-6 text-[#002395]">Gestion locative professionnelle à Paris</h2>
                <p className="text-lg text-gray-700 mb-6">
                  DOGES est votre <strong>administrateur de biens de référence à Paris</strong>. Notre agence jeune et
                  dynamique apporte un regard neuf sur la gestion locative à Paris. Nous offrons un service de gestion
                  locative complet et personnalisé pour les propriétaires d'appartements et de locaux commerciaux dans
                  la capitale.
                </p>
                <p className="text-lg text-gray-700 mb-6">
                  Notre connaissance approfondie du marché parisien et notre réseau local nous permettent de vous
                  proposer une <strong>gestion immobilière professionnelle</strong> adaptée aux spécificités de chaque
                  arrondissement de Paris.
                </p>
              </div>

              {/* Carte de Paris avec nos zones d'intervention */}
              <div id="zones">
                <h3 className="text-2xl font-semibold mb-6">Nos zones d'intervention à Paris</h3>
                <div className="relative h-[400px] rounded-xl overflow-hidden mb-6">
                  <Image
                    src="/paris-arrondissements-map.png"
                    alt="Carte des arrondissements de Paris"
                    fill
                    className="object-contain"
                  />
                </div>
                <div className="flex flex-wrap gap-2">
                  {parisDistricts.map((district, index) => (
                    <span key={index} className="bg-gray-100 text-gray-800 text-sm px-3 py-1 rounded-full">
                      {district}
                    </span>
                  ))}
                </div>
              </div>

              {/* Services spécifiques à Paris */}
              <div id="services">
                <h3 className="text-2xl font-semibold mb-6">Nos services de gestion locative à Paris</h3>
                <div className="grid md:grid-cols-2 gap-6">
                  {[
                    {
                      title: "Recherche de locataires qualifiés",
                      description: "Sélection rigoureuse de locataires solvables pour votre bien parisien",
                    },
                    {
                      title: "Gestion des loyers",
                      description: "Encaissement des loyers et charges, relances en cas d'impayés",
                    },
                    {
                      title: "Suivi technique",
                      description: "Gestion des travaux et interventions techniques dans votre bien",
                    },
                    {
                      title: "Gestion administrative",
                      description: "Rédaction des baux, états des lieux, quittances et régularisation des charges",
                    },
                    {
                      title: "Optimisation fiscale",
                      description: "Conseils pour optimiser la fiscalité de votre investissement locatif à Paris",
                    },
                    {
                      title: "Veille juridique",
                      description: "Suivi des évolutions législatives spécifiques au marché parisien",
                    },
                  ].map((service, index) => (
                    <div key={index} className="bg-white rounded-xl shadow-sm p-6 border border-gray-100">
                      <h4 className="text-lg font-semibold mb-2">{service.title}</h4>
                      <p className="text-gray-700">{service.description}</p>
                    </div>
                  ))}
                </div>
              </div>

              {/* Avantages de notre gestion locative à Paris */}
              <div id="avantages">
                <h3 className="text-2xl font-semibold mb-6">Pourquoi choisir DOGES pour gérer votre bien à Paris ?</h3>
                <div className="space-y-4">
                  {[
                    {
                      title: "Expertise locale",
                      description:
                        "Notre équipe connaît parfaitement le marché immobilier parisien et ses spécificités par arrondissement.",
                    },
                    {
                      title: "Réseau de professionnels",
                      description:
                        "Nous collaborons avec un réseau d'artisans et de prestataires de confiance à Paris pour l'entretien de votre bien.",
                    },
                    {
                      title: "Transparence totale",
                      description:
                        "Accès à votre espace client en ligne pour suivre en temps réel la gestion de votre bien.",
                    },
                    {
                      title: "Tarifs compétitifs",
                      description:
                        "Des honoraires adaptés au marché parisien, à partir de 3,9% HT des loyers encaissés.",
                    },
                  ].map((advantage, index) => (
                    <div key={index} className="flex items-start">
                      <div className="mt-1 mr-3 bg-[#002395] rounded-full p-1">
                        <Check className="h-4 w-4 text-white" />
                      </div>
                      <div>
                        <h4 className="font-semibold">{advantage.title}</h4>
                        <p className="text-gray-700">{advantage.description}</p>
                      </div>
                    </div>
                  ))}
                </div>
              </div>

              {/* Section tarifs */}
              <div id="tarifs">
                <h3 className="text-2xl font-semibold mb-6">
                  <Link href="/tarifs" className="hover:text-[#001875] hover:underline">
                    Tarifs de gestion locative à Paris
                  </Link>
                </h3>
                <div className="bg-white rounded-xl shadow-sm p-6 border border-gray-100">
                  <p className="text-lg text-gray-700 mb-4">
                    Nos tarifs de gestion locative à Paris sont transparents et adaptés à vos besoins. Nous proposons
                    trois formules :
                  </p>
                  <div className="grid md:grid-cols-3 gap-6 mt-6">
                    <div className="border rounded-lg p-4">
                      <h4 className="text-xl font-bold text-center mb-2">Essentiel</h4>
                      <div className="text-3xl font-bold text-center text-[#002395] mb-2">3,9% HT</div>
                      <p className="text-center text-sm text-gray-500 mb-4">des loyers encaissés</p>
                      <ul className="space-y-2">
                        <li className="flex items-start">
                          <Check className="h-4 w-4 text-[#002395] mr-2 mt-1" />
                          <span className="text-sm">Recherche et sélection de locataires</span>
                        </li>
                        <li className="flex items-start">
                          <Check className="h-4 w-4 text-[#002395] mr-2 mt-1" />
                          <span className="text-sm">Encaissement des loyers</span>
                        </li>
                        <li className="flex items-start">
                          <Check className="h-4 w-4 text-[#002395] mr-2 mt-1" />
                          <span className="text-sm">Révision annuelle du loyer</span>
                        </li>
                      </ul>
                    </div>
                    <div className="border rounded-lg p-4 bg-gray-50 transform scale-105 border-[#002395]">
                      <h4 className="text-xl font-bold text-center mb-2">Premium</h4>
                      <div className="text-3xl font-bold text-center text-[#002395] mb-2">4,9% HT</div>
                      <p className="text-center text-sm text-gray-500 mb-4">des loyers encaissés</p>
                      <ul className="space-y-2">
                        <li className="flex items-start">
                          <Check className="h-4 w-4 text-[#002395] mr-2 mt-1" />
                          <span className="text-sm">Tous les services Essentiel</span>
                        </li>
                        <li className="flex items-start">
                          <Check className="h-4 w-4 text-[#002395] mr-2 mt-1" />
                          <span className="text-sm">Gestion technique du bien</span>
                        </li>
                        <li className="flex items-start">
                          <Check className="h-4 w-4 text-[#002395] mr-2 mt-1" />
                          <span className="text-sm">Suivi des travaux</span>
                        </li>
                      </ul>
                    </div>
                    <div className="border rounded-lg p-4">
                      <h4 className="text-xl font-bold text-center mb-2">Sérénité</h4>
                      <div className="text-3xl font-bold text-center text-[#002395] mb-2">5,9% HT</div>
                      <p className="text-center text-sm text-gray-500 mb-4">des loyers encaissés</p>
                      <ul className="space-y-2">
                        <li className="flex items-start">
                          <Check className="h-4 w-4 text-[#002395] mr-2 mt-1" />
                          <span className="text-sm">Tous les services Premium</span>
                        </li>
                        <li className="flex items-start">
                          <Check className="h-4 w-4 text-[#002395] mr-2 mt-1" />
                          <span className="text-sm">Garantie loyers impayés</span>
                        </li>
                        <li className="flex items-start">
                          <Check className="h-4 w-4 text-[#002395] mr-2 mt-1" />
                          <span className="text-sm">Assurance PNO</span>
                        </li>
                      </ul>
                    </div>
                  </div>
                  <div className="mt-6 text-center">
                    <Link
                      href="/tarifs"
                      className="text-[#002395] hover:underline font-medium flex items-center justify-center"
                    >
                      Voir tous nos tarifs détaillés <ArrowRight className="ml-1 h-4 w-4" />
                    </Link>
                  </div>
                </div>
              </div>

              {/* FAQ pour le SEO */}
              <div id="faq">
                <h3 className="text-2xl font-semibold mb-6">Questions fréquentes sur la gestion locative à Paris</h3>
                <div className="space-y-6">
                  {[
                    {
                      question: "Quel est le prix moyen d'une gestion locative à Paris ?",
                      answer:
                        "Les honoraires de gestion locative à Paris varient généralement entre 3,9% et 8% HT des loyers encaissés, selon le niveau de service et la complexité de la gestion. Chez DOGES, nos tarifs débutent à 3,9% HT pour une gestion Essentiel et peuvent aller jusqu'à 5,9% HT pour une gestion Sérénité avec garantie loyers impayés.",
                    },
                    {
                      question: "Comment trouver un bon gestionnaire immobilier à Paris ?",
                      answer:
                        "Pour trouver un bon gestionnaire immobilier à Paris, vérifiez son expertise sur le marché parisien, sa carte professionnelle, ses avis clients et sa connaissance des spécificités locales. DOGES répond à tous ces critères avec une équipe de professionnels passionnés.",
                    },
                    {
                      question: "Quelles sont les particularités de la gestion locative à Paris ?",
                      answer:
                        "La gestion locative à Paris présente des particularités comme l'encadrement des loyers, une forte demande locative, des immeubles anciens nécessitant un suivi technique spécifique et une réglementation stricte. Notre expertise locale nous permet de naviguer efficacement dans ces spécificités.",
                    },
                  ].map((item, index) => (
                    <div key={index} className="bg-white rounded-lg shadow-sm p-6 border border-gray-100">
                      <h4 className="text-lg font-semibold mb-2">{item.question}</h4>
                      <p className="text-gray-700">{item.answer}</p>
                    </div>
                  ))}
                </div>
              </div>

              {/* CTA */}
              <div className="bg-gradient-to-r from-[#002395] to-[#001875] text-white p-8 rounded-xl">
                <h3 className="text-2xl font-bold mb-4">Confiez-nous la gestion de votre bien à Paris</h3>
                <p className="mb-6">
                  Bénéficiez de notre expertise locale et de notre service personnalisé pour une gestion sans souci de
                  votre bien parisien.
                </p>
                <div className="flex flex-col sm:flex-row gap-4">
                  <Button className="bg-white text-[#002395] hover:bg-gray-100">
                    Prendre rendez-vous
                    <ArrowRight className="ml-2 h-4 w-4" />
                  </Button>
                  <Button className="bg-transparent border border-white text-white hover:bg-white hover:text-[#002395]">
                    Demander un devis
                    <ArrowRight className="ml-2 h-4 w-4" />
                  </Button>
                </div>
              </div>
            </div>

            {/* Sidebar - 1/3 colonne */}
            <div className="space-y-8">
              {/* Table des matières pour desktop */}
              <div className="hidden lg:block sticky top-24 bg-white rounded-xl shadow-lg p-6 border border-gray-100">
                <h3 className="text-xl font-semibold mb-4">Table des matières</h3>
                <nav className="toc">
                  <ul className="space-y-2">
                    {tableOfContentsHeadings.map((heading) => (
                      <li key={heading.id} className={`${heading.level === 3 ? "ml-4" : ""}`}>
                        <a
                          href={`#${heading.id}`}
                          className="block py-1 border-l-2 pl-3 text-sm hover:text-[#002395] transition-colors border-gray-200 text-gray-600"
                          onClick={(e) => {
                            e.preventDefault()
                            document.getElementById(heading.id)?.scrollIntoView({
                              behavior: "smooth",
                            })
                            // Update URL without page reload
                            window.history.pushState(null, "", `#${heading.id}`)
                          }}
                        >
                          {heading.text}
                        </a>
                      </li>
                    ))}
                  </ul>
                </nav>
              </div>

              {/* Calculateur de frais */}
              <div id="calculateur">
                <FeeCalculator />
              </div>

              {/* Widgets de blog */}
              <ServicesSidebarWidgets />

              {/* Témoignages */}
              <div className="bg-white rounded-xl shadow-lg p-6 border border-gray-100" id="temoignages">
                <h3 className="text-xl font-semibold mb-4">Ce que disent nos clients parisiens</h3>
                <div className="space-y-4">
                  {[
                    {
                      text: "DOGES gère mon appartement dans le 16ème depuis un an. Service impeccable et réactivité exemplaire.",
                      name: "Pierre D.",
                      district: "Paris 16ème",
                    },
                    {
                      text: "Grâce à leur expertise du marché parisien, mon studio est toujours loué au meilleur prix et sans vacance locative.",
                      name: "Sophie M.",
                      district: "Paris 8ème",
                    },
                  ].map((testimonial, index) => (
                    <div key={index} className="bg-gray-50 p-4 rounded-lg">
                      <p className="italic text-gray-700 mb-2">"{testimonial.text}"</p>
                      <div className="text-sm font-medium">
                        {testimonial.name} - <span className="text-[#002395]">{testimonial.district}</span>
                      </div>
                    </div>
                  ))}
                </div>
              </div>

              {/* Contact rapide */}
              <div className="bg-white rounded-xl shadow-lg p-6 border border-gray-100">
                <h3 className="text-xl font-semibold mb-4" id="contact">
                  Contact rapide
                </h3>
                <div className="space-y-4 mb-4">
                  <div className="flex items-center">
                    <MapPin className="h-5 w-5 text-[#002395] mr-3" />
                    <span>92, Avenue de Saint-Mandé Paris 12e</span>
                  </div>
                  <div className="flex items-center">
                    <Phone className="h-5 w-5 text-[#002395] mr-3" />
                    <span>01 84 80 98 10</span>
                  </div>
                  <div className="flex items-center">
                    <Mail className="h-5 w-5 text-[#002395] mr-3" />
                    <span>contact@dogesadb.fr</span>
                  </div>
                </div>
                <form className="space-y-4">
                  <input type="text" placeholder="Votre nom" className="w-full px-3 py-2 border rounded-md" />
                  <input type="email" placeholder="Votre email" className="w-full px-3 py-2 border rounded-md" />
                  <input type="tel" placeholder="Votre téléphone" className="w-full px-3 py-2 border rounded-md" />
                  <Button className="w-full bg-[#002395] text-white hover:bg-[#001875]">Être rappelé</Button>
                </form>
              </div>
            </div>
          </div>
        </div>
      </section>

      {/* Section liens vers autres arrondissements pour SEO */}
      <section className="container py-12 md:py-16">
        <h2 className="text-3xl font-bold text-center mb-8">Gestion locative dans tous les arrondissements de Paris</h2>
        <ArrondissementLinks />
      </section>
    </>
  )
}
