"use client"

import { useEffect } from "react"

export default function Error({
  error,
  reset,
}: {
  error: Error & { digest?: string }
  reset: () => void
}) {
  useEffect(() => {
    console.error("Erreur dans la page gestion-locative:", error)
  }, [error])

  return (
    <div className="container mx-auto px-4 py-16">
      <h1 className="text-3xl font-bold text-red-600 mb-6">Erreur</h1>
      <p className="text-lg mb-4">Une erreur s'est produite lors du chargement de cette page.</p>
      <p className="text-sm text-gray-600 mb-6">{error.message || "Erreur inconnue"}</p>
      <button onClick={reset} className="px-4 py-2 bg-[#002395] text-white rounded-md">
        Réessayer
      </button>
    </div>
  )
}
