import type { Metadata } from "next"
import Link from "next/link"
import Image from "next/image"
import { ArrowRight } from "lucide-react"
import { Button } from "@/components/ui/button"
import PageHeader from "@/components/page-header"

export const metadata: Metadata = {
  title: "Nos Services | DOGES Administrateur de Biens",
  description:
    "Découvrez nos services de gestion locative, comptabilité, transaction, juridique et plus encore à Paris et en Île-de-France.",
}

export default function ServicesPage() {
  // Remplacer le tableau mainServices par celui-ci avec des images réelles
  const mainServices = [
    {
      title: "Gestion Locative",
      description:
        "Confiez-nous la gestion complète de votre bien immobilier : recherche de locataires, encaissement des loyers, gestion des travaux, etc.",
      image: "/modern-apartment-interior.png",
      link: "/services/gestion-locative",
    },
    {
      title: "Transaction",
      description:
        "Nous mettons tout en œuvre pour faciliter la vie des propriétaires qui souhaitent louer ou vendre leur bien immobilier avec un accompagnement personnalisé.",
      image: "/images/transaction-service.webp",
      link: "/services/transaction",
    },
    {
      title: "Garantie loyers impayés",
      description:
        "Nous comprenons que la sécurité financière est une préoccupation majeure pour les propriétaires, c'est pourquoi nous proposons une garantie loyers impayés efficace.",
      image: "/rental-income-protection-security.png",
      link: "/services/garantie-loyers-impayes",
    },
    {
      title: "Assurance Propriétaire non occupant",
      description:
        "Sécurisez votre patrimoine immobilier avec l'assurance propriétaire non occupant de Doges pour une protection complète de votre investissement.",
      image: "/images/assurance-pno-service.webp",
      link: "/services/assurance-pno",
    },
    {
      title: "Comptabilité mandants",
      description:
        "Optimisez la gestion financière de vos biens immobiliers avec le service de comptabilité mandant exceptionnel de Doges pour un suivi précis et transparent.",
      image: "/real-estate-accounting-documents.png",
      link: "/services/comptabilite-mandants",
    },
    {
      title: "Juridique",
      description:
        "Doges met à votre disposition un service juridique expérimenté et spécialisé dans la gestion locative et immobilière pour sécuriser vos opérations.",
      image: "/legal-real-estate-professional-contract.png",
      link: "/services/juridique",
    },
    {
      title: "Service Commercial",
      description:
        "Notre équipe commerciale vous accompagne dans tous vos projets immobiliers avec expertise et professionnalisme pour maximiser votre satisfaction.",
      image: "/images/commercial-service.webp",
      link: "/services/service-commercial",
    },
    {
      title: "Professionnels",
      description:
        "Notre société d'administration de biens propose une offre de partenariat complète et personnalisée aux professionnels de l'immobilier pour une collaboration fructueuse.",
      image: "/images/professional-services.png",
      link: "/services/professionnels",
    },
  ]

  // Services spécialisés avec les nouvelles images
  const seoServices = [
    {
      title: "Gestion Locative Paris",
      description:
        "Une gestion locative spécifiquement adaptée au marché parisien et à ses particularités pour les propriétaires de biens dans la capitale.",
      image: "/paris-panorama.png",
      link: "/services/gestion-locative-paris",
    },
    {
      title: "Gestion Locative Île-de-France",
      description:
        "Notre service de gestion locative s'étend à toute l'Île-de-France pour les propriétaires de biens en petite et grande couronne.",
      image: "/professional-property-management.jpg",
      link: "/services/gestion-locative-ile-de-france",
    },
    {
      title: "Administrateur de Biens",
      description:
        "Notre expertise d'administrateur de biens vous garantit une gestion professionnelle et personnalisée de votre patrimoine immobilier.",
      image: "https://hebbkx1anhila5yf.public.blob.vercel-storage.com/image-izBnw2HjE1UPNNoHqkgIlaj095CohC.png",
      link: "/services/administrateur-biens-paris",
    },
    {
      title: "Administrateur de Biens Paris",
      description:
        "Une expertise locale d'administrateur de biens pour une gestion optimale de votre patrimoine immobilier parisien.",
      image: "https://hebbkx1anhila5yf.public.blob.vercel-storage.com/image-litoaHC4ffMB1DfJhv26q5NTtLSR6S.png",
      link: "/services/administrateur-biens-paris",
    },
    {
      title: "Administrateur de Biens Hauts-de-Seine",
      description:
        "Notre expertise d'administrateur de biens dans les Hauts-de-Seine (92) pour une gestion optimale de votre patrimoine immobilier.",
      image: "https://hebbkx1anhila5yf.public.blob.vercel-storage.com/image-Q3ph4wfmLF1yA3LaUs4V8j6R41onbk.png",
      link: "/services/administrateur-biens-hauts-de-seine",
    },
    {
      title: "Administrateur de Biens Île-de-France",
      description:
        "Notre équipe d'administrateurs de biens intervient dans toute l'Île-de-France pour une gestion de proximité.",
      image: "https://hebbkx1anhila5yf.public.blob.vercel-storage.com/image-BasNvfrmEVzdzw5lCVRkwoN31rqmam.png",
      link: "/services/administrateur-biens-ile-de-france",
    },
    {
      title: "Gestion Immobilière Professionnelle",
      description:
        "Une gestion immobilière professionnelle pour optimiser la rentabilité de votre patrimoine et vous libérer des contraintes administratives.",
      image: "https://hebbkx1anhila5yf.public.blob.vercel-storage.com/image-iCBOzQwHAqeFd6myUNgzzDn3xyWScd.png",
      link: "/services/gestion-immobiliere-professionnelle",
    },
  ]

  return (
    <>
      <PageHeader
        title="Nos Services"
        description="Des solutions de gestion immobilière sur mesure pour votre patrimoine"
        backgroundImage="https://hebbkx1anhila5yf.public.blob.vercel-storage.com/image-rPq0DlYLFqdOjoptWzEcEfyqoDN6Ak.png"
        breadcrumbs={[{ label: "Services", href: "/services" }]}
      />

      <section className="py-16">
        <div className="container mx-auto px-4">
          <div className="max-w-3xl mx-auto mb-12 text-center">
            <h2 className="text-3xl font-bold mb-4">Une offre complète de services immobiliers</h2>
            <p className="text-lg text-gray-700">
              DOGES vous propose une gamme complète de services pour répondre à tous vos besoins en matière de gestion
              immobilière à Paris et en Île-de-France.
            </p>
          </div>

          <h3 className="text-2xl font-bold mb-6">Nos Services Principaux</h3>
          <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-8 mb-16">
            {mainServices.map((service, index) => (
              <Link key={index} href={service.link} className="block">
                <div className="group bg-white rounded-2xl overflow-hidden shadow-lg hover:shadow-2xl transition-all duration-500 flex flex-col h-full transform hover:scale-105 cursor-pointer">
                  <div className="relative h-48 overflow-hidden">
                    <Image
                      src={service.image || "/placeholder.svg"}
                      alt={service.title}
                      fill
                      className="object-cover transition-transform duration-500 group-hover:scale-110"
                      unoptimized={service.image.startsWith("http")}
                    />
                    <div className="absolute inset-0 bg-gradient-to-t from-black/20 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-300" />
                  </div>
                  <div className="p-6 flex flex-col flex-grow">
                    <h3 className="text-xl font-bold mb-2 group-hover:text-[#002395] transition-colors duration-300">
                      {service.title}
                    </h3>
                    <p className="text-gray-700 mb-4 flex-grow">{service.description}</p>
                    <div className="mt-auto">
                      <Button
                        variant="outline"
                        className="w-full group-hover:bg-[#002395] group-hover:text-white group-hover:border-[#002395] transition-all duration-300 pointer-events-none"
                      >
                        Découvrir
                        <ArrowRight className="ml-2 h-4 w-4 group-hover:translate-x-1 transition-transform duration-300" />
                      </Button>
                    </div>
                  </div>
                </div>
              </Link>
            ))}
          </div>

          <h3 className="text-2xl font-bold mb-6">Services Spécialisés par Région</h3>
          <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
            {seoServices.map((service, index) => (
              <Link key={index} href={service.link} className="block">
                <div className="group bg-white rounded-2xl overflow-hidden shadow-lg hover:shadow-2xl transition-all duration-500 flex flex-col h-full transform hover:scale-105 cursor-pointer">
                  <div className="relative h-48 overflow-hidden">
                    <Image
                      src={service.image || "/placeholder.svg"}
                      alt={service.title}
                      fill
                      className="object-cover transition-transform duration-500 group-hover:scale-110"
                      unoptimized={service.image.startsWith("http")}
                    />
                    <div className="absolute inset-0 bg-gradient-to-t from-black/20 to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-300" />
                  </div>
                  <div className="p-6 flex flex-col flex-grow">
                    <h3 className="text-xl font-bold mb-2 group-hover:text-[#002395] transition-colors duration-300">
                      {service.title}
                    </h3>
                    <p className="text-gray-700 mb-4 flex-grow">{service.description}</p>
                    <div className="mt-auto">
                      <Button
                        variant="outline"
                        className="w-full group-hover:bg-[#002395] group-hover:text-white group-hover:border-[#002395] transition-all duration-300 pointer-events-none"
                      >
                        Découvrir
                        <ArrowRight className="ml-2 h-4 w-4 group-hover:translate-x-1 transition-transform duration-300" />
                      </Button>
                    </div>
                  </div>
                </div>
              </Link>
            ))}
          </div>
        </div>
      </section>

      <section className="py-16 bg-gray-50">
        <div className="container mx-auto px-4">
          <div className="max-w-3xl mx-auto text-center">
            <h2 className="text-3xl font-bold mb-4">Vous avez un projet immobilier ?</h2>
            <p className="text-lg text-gray-700 mb-8">
              Notre équipe de professionnels est à votre disposition pour vous accompagner dans tous vos projets
              immobiliers.
            </p>
            <Link href="/contact">
              <Button size="lg" className="bg-[#002395] hover:bg-[#001875] text-white">
                Contactez-nous
                <ArrowRight className="ml-2 h-4 w-4" />
              </Button>
            </Link>
          </div>
        </div>
      </section>
    </>
  )
}
