"use client"

import { useState } from "react"
import { Card, CardContent } from "@/components/ui/card"
import { Slider } from "@/components/ui/slider"

export default function SidebarCalculator() {
  const [activeTab, setActiveTab] = useState<"achat" | "vente">("achat")
  const [propertyPrice, setPropertyPrice] = useState(730000)
  const [isNewProperty, setIsNewProperty] = useState(false)

  // Calcul des frais
  const notaryFees = isNewProperty
    ? Math.round(propertyPrice * 0.02) // 2% pour le neuf
    : Math.round(propertyPrice * 0.08) // 8% pour l'ancien

  const agencyFees = Math.round(propertyPrice * 0.05) // 5% d'honoraires

  // Calcul différent selon l'onglet actif
  const totalPrice = activeTab === "achat" ? propertyPrice + notaryFees + agencyFees : propertyPrice

  const netVendeur = activeTab === "vente" ? propertyPrice - agencyFees : 0

  return (
    <Card className="mb-6">
      <CardContent className="p-4">
        <h3 className="text-xl font-bold mb-4">Calculateur rapide</h3>

        {/* Tabs */}
        <div className="grid grid-cols-2 gap-0 mb-6 h-12 rounded-md overflow-hidden">
          <button
            className={`h-full flex items-center justify-center font-medium ${
              activeTab === "achat" ? "bg-[#002395] text-white" : "bg-gray-100 text-gray-700 hover:bg-gray-200"
            }`}
            onClick={() => setActiveTab("achat")}
          >
            Achat
          </button>
          <button
            className={`h-full flex items-center justify-center font-medium ${
              activeTab === "vente" ? "bg-[#002395] text-white" : "bg-gray-100 text-gray-700 hover:bg-gray-200"
            }`}
            onClick={() => setActiveTab("vente")}
          >
            Vente
          </button>
        </div>

        {/* Prix du bien */}
        <div className="mb-4">
          <div className="flex justify-between mb-2">
            <label className="font-medium">Prix du bien</label>
            <span className="font-bold">{propertyPrice.toLocaleString()} €</span>
          </div>
          <Slider
            defaultValue={[propertyPrice]}
            min={100000}
            max={2000000}
            step={10000}
            onValueChange={(value) => setPropertyPrice(value[0])}
            className="my-4"
          />
        </div>

        {/* Type de bien - toujours visible */}
        <div className="grid grid-cols-2 gap-4 mb-6">
          <button
            className={`py-3 px-4 rounded font-medium ${
              !isNewProperty ? "bg-[#002395] text-white" : "border border-gray-300 text-gray-700 hover:border-[#002395]"
            }`}
            onClick={() => setIsNewProperty(false)}
          >
            Ancien
          </button>
          <button
            className={`py-3 px-4 rounded font-medium ${
              isNewProperty ? "bg-[#002395] text-white" : "border border-gray-300 text-gray-700 hover:border-[#002395]"
            }`}
            onClick={() => setIsNewProperty(true)}
          >
            Neuf
          </button>
        </div>

        {/* Résumé des frais - différent selon l'onglet */}
        <div className="space-y-2 mb-6">
          {activeTab === "achat" ? (
            <>
              <div className="flex justify-between">
                <span>Frais de notaire ({isNewProperty ? "2%" : "8%"})</span>
                <span className="font-medium">{notaryFees.toLocaleString()} €</span>
              </div>
              <div className="flex justify-between">
                <span>Honoraires (5%)</span>
                <span className="font-medium">{agencyFees.toLocaleString()} €</span>
              </div>
              <div className="flex justify-between pt-2 border-t border-gray-200">
                <span className="font-bold">Total</span>
                <span className="font-bold">{totalPrice.toLocaleString()} €</span>
              </div>
            </>
          ) : (
            <>
              <div className="flex justify-between">
                <span>Honoraires (5%)</span>
                <span className="font-medium">{agencyFees.toLocaleString()} €</span>
              </div>
              <div className="flex justify-between pt-2 border-t border-gray-200">
                <span className="font-bold">Net vendeur</span>
                <span className="font-bold">{netVendeur.toLocaleString()} €</span>
              </div>
            </>
          )}
        </div>

        {/* Bouton CTA */}
        <a
          href="#calculateur"
          className="block w-full bg-[#002395] hover:bg-[#001875] text-white py-3 px-4 rounded text-center font-medium"
        >
          Calculateur détaillé
        </a>
      </CardContent>
    </Card>
  )
}
