import { Check, ArrowRight } from "lucide-react"
import { Button } from "@/components/ui/button"
import PageHeader from "@/components/page-header"

export default function TarifsPage() {
  // Forfaits de gestion locative
  const managementPlans = [
    {
      name: "Essentiel",
      price: "À partir de 2% HT",
      description: "La solution idéale pour les propriétaires qui souhaitent une gestion simple et efficace.",
      features: [
        "Recherche et sélection de locataires",
        "Rédaction des baux",
        "Encaissement des loyers",
        "Révision annuelle du loyer",
        "Régularisation des charges",
        "Quittances et relevés",
      ],
      notIncluded: ["Gestion technique", "Garantie loyers impayés", "Assurance PNO", "Représentation en AG"],
    },
    {
      name: "Premium",
      price: "À partir de 3,9% HT",
      description: "Une solution complète pour une tranquillité d'esprit totale.",
      features: [
        "Tous les services du forfait Essentiel",
        "Gestion technique du bien",
        "Suivi des travaux",
        "Représentation en assemblée générale",
        "Déclaration fiscale",
        "Bilan annuel de gestion",
        "Conseils patrimoniaux",
      ],
      notIncluded: ["Garantie loyers impayés", "Assurance PNO"],
      highlighted: true,
    },
    {
      name: "Sérénité",
      price: "À partir de 6,9% HT",
      description: "La solution tout inclus pour une gestion sans souci.",
      features: [
        "Tous les services du forfait Premium",
        "Garantie loyers impayés",
        "Assurance PNO",
        "Protection juridique",
        "Gestion des sinistres",
        "Visite annuelle du bien",
        "Conciergerie",
      ],
      notIncluded: [],
    },
  ]

  // Tarifs des services complémentaires
  const additionalServices = [
    {
      service: "Mise en location",
      price: "1 mois de loyer HT",
      details: "Recherche de locataires, visites, constitution du dossier, rédaction du bail, état des lieux",
    },
    {
      service: "État des lieux",
      price: "3€/m² HT",
      details: "Réalisation de l'état des lieux d'entrée ou de sortie",
    },
    {
      service: "Garantie Loyers Impayés",
      price: "2.5% des loyers HT",
      details: "Protection contre les impayés, les dégradations et les frais de procédure",
    },
    {
      service: "Assurance PNO",
      price: "À partir de 80€/an",
      details: "Assurance pour les propriétaires non occupants",
    },
    {
      service: "Gestion technique",
      price: "À partir de 2% HT",
      details: "Suivi des travaux, interventions techniques, maintenance",
    },
    {
      service: "Déclaration fiscale",
      price: "À partir de 150€ HT",
      details: "Préparation et envoi de votre déclaration fiscale",
    },
  ]

  // FAQ sur les tarifs
  const pricingFaqs = [
    {
      question: "Comment sont calculés vos honoraires de gestion ?",
      answer:
        "Nos honoraires de gestion sont calculés en pourcentage des loyers encaissés, charges comprises. Le taux varie selon le forfait choisi et le type de bien.",
    },
    {
      question: "Y a-t-il des frais supplémentaires ?",
      answer:
        "Tous les services inclus dans votre forfait sont couverts par les honoraires de gestion. Les services complémentaires sont facturés selon la grille tarifaire.",
    },
    {
      question: "Puis-je changer de forfait en cours de contrat ?",
      answer:
        "Oui, vous pouvez changer de forfait à tout moment, sous réserve d'un préavis d'un mois. Le nouveau forfait prendra effet le mois suivant.",
    },
    {
      question: "Quelle est la durée d'engagement ?",
      answer:
        "Notre mandat de gestion est généralement d'une durée d'un an, renouvelable par tacite reconduction. Vous pouvez le résilier à tout moment moyennant un préavis de trois mois.",
    },
    {
      question: "Les honoraires sont-ils négociables ?",
      answer:
        "Nos honoraires sont déjà très compétitifs, à partir de 3,9% HT. Cependant, pour les portefeuilles importants ou les investisseurs institutionnels, nous pouvons proposer des tarifs adaptés.",
    },
  ]

  return (
    <>
      <PageHeader
        title="Nos Tarifs"
        description="Des honoraires transparents et compétitifs à partir de 2% HT"
        breadcrumbs={[{ label: "Tarifs", href: "/tarifs" }]}
        backgroundImage="https://images.unsplash.com/photo-1554224155-6726b3ff858f?q=80&w=2011&auto=format&fit=crop"
      />

      {/* Forfaits de gestion locative */}
      <section className="py-16">
        <div className="container mx-auto px-4">
          <h2 className="text-3xl font-bold mb-12 text-center text-[#002395]">Nos Forfaits de Gestion Locative</h2>

          <div className="grid md:grid-cols-3 gap-8">
            {managementPlans.map((plan, index) => (
              <div
                key={index}
                className={`rounded-xl shadow-lg overflow-hidden ${
                  plan.highlighted ? "border-2 border-[#002395] transform scale-105" : "border border-gray-200"
                }`}
              >
                {/* Header */}
                <div
                  className={`p-6 ${
                    plan.highlighted
                      ? "bg-gradient-to-r from-[#002395] to-[#001875] text-white"
                      : "bg-gray-50 text-[#002395]"
                  }`}
                >
                  <h3 className="text-2xl font-bold mb-2">{plan.name}</h3>
                  <div className="text-3xl font-bold mb-2">{plan.price}</div>
                  <p className={plan.highlighted ? "text-blue-100" : "text-gray-600"}>{plan.description}</p>
                </div>

                {/* Features */}
                <div className="p-6 bg-white">
                  <h4 className="font-semibold mb-4">Ce qui est inclus :</h4>
                  <ul className="space-y-3 mb-6">
                    {plan.features.map((feature, idx) => (
                      <li key={idx} className="flex items-start">
                        <Check className="h-5 w-5 text-green-500 mr-2 mt-0.5" />
                        <span>{feature}</span>
                      </li>
                    ))}
                  </ul>

                  {plan.notIncluded.length > 0 && (
                    <>
                      <h4 className="font-semibold mb-4">Non inclus :</h4>
                      <ul className="space-y-3 mb-6 text-gray-500">
                        {plan.notIncluded.map((feature, idx) => (
                          <li key={idx} className="flex items-start">
                            <span className="text-red-500 mr-2">✕</span>
                            <span>{feature}</span>
                          </li>
                        ))}
                      </ul>
                    </>
                  )}

                  <Button
                    variant={plan.highlighted ? "gradient" : "outline"}
                    className={`w-full ${
                      plan.highlighted
                        ? "text-white"
                        : "text-[#002395] border-[#002395] hover:bg-[#002395] hover:text-white"
                    }`}
                  >
                    Choisir ce forfait
                    <ArrowRight className="ml-2 h-4 w-4" />
                  </Button>
                </div>
              </div>
            ))}
          </div>

          <div className="mt-8 text-center text-gray-600">
            <p>
              * Les tarifs indiqués sont des tarifs de base et peuvent varier selon le type et la localisation du bien.
              Contactez-nous pour un devis personnalisé.
            </p>
          </div>
        </div>
      </section>

      {/* Services complémentaires */}
      <section className="py-16 bg-gray-50">
        <div className="container mx-auto px-4">
          <h2 className="text-3xl font-bold mb-12 text-center text-[#002395]">Services Complémentaires</h2>

          <div className="overflow-x-auto">
            <table className="w-full bg-white rounded-xl shadow-sm">
              <thead>
                <tr className="bg-[#002395] text-white">
                  <th className="py-4 px-6 text-left">Service</th>
                  <th className="py-4 px-6 text-left">Tarif</th>
                  <th className="py-4 px-6 text-left">Détails</th>
                </tr>
              </thead>
              <tbody>
                {additionalServices.map((item, index) => (
                  <tr key={index} className={index % 2 === 0 ? "bg-gray-50" : "bg-white"}>
                    <td className="py-4 px-6 font-medium">{item.service}</td>
                    <td className="py-4 px-6">{item.price}</td>
                    <td className="py-4 px-6 text-gray-600">{item.details}</td>
                  </tr>
                ))}
              </tbody>
            </table>
          </div>
        </div>
      </section>

      {/* FAQ sur les tarifs */}
      <section className="py-16">
        <div className="container mx-auto px-4">
          <h2 className="text-3xl font-bold mb-12 text-center text-[#002395]">Questions Fréquentes sur nos Tarifs</h2>

          <div className="max-w-3xl mx-auto">
            {pricingFaqs.map((faq, index) => (
              <div key={index} className="mb-8 border-b border-gray-200 pb-8 last:border-0">
                <h3 className="text-xl font-bold mb-4">{faq.question}</h3>
                <p className="text-gray-700">{faq.answer}</p>
              </div>
            ))}
          </div>
        </div>
      </section>

      {/* CTA */}
      <section className="py-16 bg-gradient-to-r from-[#002395] to-[#001875] text-white">
        <div className="container mx-auto px-4 text-center">
          <h2 className="text-3xl font-bold mb-6">Besoin d'un devis personnalisé ?</h2>
          <p className="text-xl mb-8 max-w-2xl mx-auto">
            Contactez-nous dès aujourd'hui pour obtenir un devis adapté à vos besoins spécifiques.
          </p>
          <div className="flex flex-col sm:flex-row justify-center gap-4">
            <Button variant="white" className="text-[#002395] hover:bg-gray-100">
              Demander un devis
              <ArrowRight className="ml-2 h-4 w-4" />
            </Button>
            <Button variant="outline" className="border-white text-white hover:bg-white hover:text-[#002395]">
              Nous contacter
            </Button>
          </div>
        </div>
      </section>
    </>
  )
}
