import  PageHeader  from "@/components/page-header"
import  TableOfContentsWidget  from "@/components/table-of-contents-widget"
import { ContactWidget } from "@/components/contact-widget"
import RelatedServicesWidget  from "@/components/related-services-widget"

export default function TestComponentsPage() {
  const tableOfContentsItems = [
    { id: "section-1", title: "Section 1 - Test" },
    { id: "section-2", title: "Section 2 - Composants" },
    { id: "section-3", title: "Section 3 - Vérification" },
  ]

  const relatedServices = [
    {
      title: "Service Test 1",
      description: "Description du premier service de test",
      link: "/services/test-1",
    },
    {
      title: "Service Test 2",
      description: "Description du deuxième service de test",
      link: "/services/test-2",
    },
  ]

  return (
    <div className="min-h-screen bg-gray-50">
      {/* Test du PageHeader */}
      <PageHeader
        title="Page de Test des Composants"
        description="Vérification que tous les composants s'affichent correctement"
        breadcrumbs={[
          { label: "Test", href: "/test" },
          { label: "Composants", href: "/test-components" },
        ]}
        backgroundImage="/parisian-street-new.png"
      />

      <div className="container mx-auto px-4 py-12">
        <div className="grid grid-cols-1 lg:grid-cols-3 gap-8">
          {/* Contenu principal */}
          <div className="lg:col-span-2">
            <section id="section-1" className="mb-12">
              <h2 className="text-2xl font-bold text-[#002395] mb-6">Section 1 - Test du PageHeader</h2>
              <div className="bg-white p-6 rounded-lg shadow-md">
                <h3 className="text-xl font-semibold mb-3">✅ PageHeader</h3>
                <p className="text-gray-600 mb-4">Le composant PageHeader s'affiche correctement avec :</p>
                <ul className="list-disc pl-6 space-y-2 text-gray-600">
                  <li>Titre principal en blanc sur fond bleu</li>
                  <li>Description sous le titre</li>
                  <li>Fil d'Ariane intégré dans l'en-tête</li>
                  <li>Image de fond avec overlay</li>
                  <li>Navigation accessible</li>
                </ul>
              </div>
            </section>

            <section id="section-2" className="mb-12">
              <h2 className="text-2xl font-bold text-[#002395] mb-6">Section 2 - Test des Widgets</h2>
              <div className="bg-white p-6 rounded-lg shadow-md">
                <h3 className="text-xl font-semibold mb-3">✅ Widgets de Sidebar</h3>
                <p className="text-gray-600 mb-4">Les widgets de la sidebar s'affichent correctement :</p>
                <ul className="list-disc pl-6 space-y-2 text-gray-600">
                  <li>TableOfContentsWidget - Navigation dans la page</li>
                  <li>ContactWidget - Informations de contact</li>
                  <li>RelatedServicesWidget - Services associés</li>
                </ul>
              </div>
            </section>

            <section id="section-3" className="mb-12">
              <h2 className="text-2xl font-bold text-[#002395] mb-6">Section 3 - Vérification des Exports</h2>
              <div className="bg-white p-6 rounded-lg shadow-md">
                <h3 className="text-xl font-semibold mb-3">✅ Imports/Exports</h3>
                <p className="text-gray-600 mb-4">Tous les exports ont été corrigés :</p>
                <ul className="list-disc pl-6 space-y-2 text-gray-600">
                  <li>PageHeader - Export par défaut et nommé</li>
                  <li>TableOfContentsWidget - Export nommé ajouté</li>
                  <li>ContactWidget - Export nommé ajouté</li>
                  <li>RelatedServicesWidget - Export nommé ajouté</li>
                  <li>blogImages - Export nommé ajouté dans lib/blog-images.ts</li>
                </ul>
              </div>
            </section>
          </div>

          {/* Sidebar avec tous les widgets */}
          <div className="lg:col-span-1">
            <div className="sticky top-8 space-y-6">
              {/* Test TableOfContentsWidget */}
              <TableOfContentsWidget items={tableOfContentsItems} />

              {/* Test ContactWidget */}
              <ContactWidget />

              {/* Test RelatedServicesWidget */}
              <RelatedServicesWidget services={relatedServices} />
            </div>
          </div>
        </div>
      </div>
    </div>
  )
}
