"use client"

import Image from "next/image"
import { Breadcrumb } from "@/components/breadcrumb"

interface BreadcrumbItem {
  name: string
  url: string
}

interface PageHeaderProps {
  title: string
  description: string
  breadcrumbItems: BreadcrumbItem[]
  backgroundImage?: string
}

export default function PageHeader({ title, description, breadcrumbItems, backgroundImage }: PageHeaderProps) {
  return (
    <>
      {/* En-tête avec image de fond */}
      <div className="relative h-[300px] md:h-[400px] w-full">
        {backgroundImage && (
          <Image
            src={backgroundImage || "/placeholder.svg"}
            alt={title}
            fill
            className="object-cover brightness-75"
            priority
          />
        )}
        <div className="absolute inset-0 bg-[#002395]/80"></div>

        {/* Contenu aligné à gauche avec padding pour éviter le header fixe */}
        <div className="absolute inset-0 flex flex-col justify-start pt-36">
          <div className="container mx-auto px-4 md:px-6">
            {/* Fil d'Ariane en haut */}
            <div className="mb-6 md:mb-8">
              <Breadcrumb items={breadcrumbItems} className="text-white/90" />
            </div>

            {/* Titre et description alignés à gauche */}
            <div className="max-w-4xl">
              <h1 className="text-3xl md:text-4xl lg:text-5xl font-bold text-white mb-4 md:mb-6 drop-shadow-lg text-left">
                {title}
              </h1>
              <p className="text-lg md:text-xl text-white/95 max-w-2xl drop-shadow-lg text-left leading-relaxed">
                {description}
              </p>
            </div>
          </div>
        </div>
      </div>
    </>
  )
}
