"use client"

import type React from "react"

import { useState } from "react"
import { Dialog, DialogContent, DialogHeader, DialogTitle, DialogTrigger } from "@/components/ui/dialog"
import { Button } from "@/components/ui/button"
import { Input } from "@/components/ui/input"
import { Label } from "@/components/ui/label"
import { Calendar } from "@/components/ui/calendar"
import { fr } from "date-fns/locale"

export default function AppointmentModal() {
  const [date, setDate] = useState<Date>()
  const [time, setTime] = useState("")

  const handleSubmit = (e: React.FormEvent) => {
    e.preventDefault()
    // Intégrer avec un système de réservation
    console.log("Rendez-vous demandé:", { date, time })
  }

  return (
    <Dialog>
      <DialogTrigger asChild>
        <Button className="bg-gradient-to-r from-[#002395] to-[#001875]">Prendre rendez-vous</Button>
      </DialogTrigger>
      <DialogContent className="sm:max-w-[425px]">
        <DialogHeader>
          <DialogTitle>Prendre rendez-vous</DialogTitle>
        </DialogHeader>
        <form onSubmit={handleSubmit} className="space-y-4">
          <div className="space-y-2">
            <Label>Nom complet</Label>
            <Input required placeholder="Votre nom" />
          </div>
          <div className="space-y-2">
            <Label>Email</Label>
            <Input required type="email" placeholder="votre@email.com" />
          </div>
          <div className="space-y-2">
            <Label>Téléphone</Label>
            <Input required type="tel" placeholder="Votre numéro" />
          </div>
          <div className="space-y-2">
            <Label>Date</Label>
            <Calendar mode="single" selected={date} onSelect={setDate} locale={fr} className="rounded-md border" />
          </div>
          <div className="space-y-2">
            <Label>Heure</Label>
            <select
              className="w-full p-2 border rounded-md"
              value={time}
              onChange={(e) => setTime(e.target.value)}
              required
            >
              <option value="">Sélectionner une heure</option>
              {Array.from({ length: 8 }, (_, i) => i + 9).map((hour) => (
                <option key={hour} value={`${hour}:00`}>
                  {hour}:00
                </option>
              ))}
            </select>
          </div>
          <Button type="submit" className="w-full">
            Confirmer le rendez-vous
          </Button>
        </form>
      </DialogContent>
    </Dialog>
  )
}
