"use client"

import { useEffect } from "react"

interface BlogArticleSchemaProps {
  title: string
  description: string
  datePublished: string
  dateModified?: string
  authorName: string
  authorUrl?: string
  imageUrl: string
  articleUrl: string
  category: string
}

export function BlogArticleSchema({
  title,
  description,
  datePublished,
  dateModified,
  authorName,
  authorUrl,
  imageUrl,
  articleUrl,
  category,
}: BlogArticleSchemaProps) {
  useEffect(() => {
    // Créer le schéma JSON-LD pour l'article de blog
    const schema = {
      "@context": "https://schema.org",
      "@type": "BlogPosting",
      headline: title,
      description: description,
      image: imageUrl,
      datePublished: datePublished,
      dateModified: dateModified || datePublished,
      author: {
        "@type": "Person",
        name: authorName,
        url: authorUrl,
      },
      publisher: {
        "@type": "Organization",
        name: "DOGES",
        logo: {
          "@type": "ImageObject",
          url: "https://www.doges.fr/logo.png",
        },
      },
      mainEntityOfPage: {
        "@type": "WebPage",
        "@id": articleUrl,
      },
      articleSection: category,
    }

    // Ajouter le schéma à la page
    const script = document.createElement("script")
    script.type = "application/ld+json"
    script.text = JSON.stringify(schema)
    document.head.appendChild(script)

    // Nettoyer lors du démontage du composant
    return () => {
      document.head.removeChild(script)
    }
  }, [title, description, datePublished, dateModified, authorName, authorUrl, imageUrl, articleUrl, category])

  return null
}
