"use client"

import Image from "next/image"

type CityHeaderImageProps = {
  cityName: string
  citySlug: string
  className?: string
  overlay?: boolean
  overlayColor?: string
  overlayOpacity?: number
}

export default function CityHeaderImage({
  cityName,
  citySlug,
  className = "",
  overlay = true,
  overlayColor = "#002395",
  overlayOpacity = 0.7,
}: CityHeaderImageProps) {
  // Utilisons directement le placeholder pour éviter les problèmes d'erreur d'image
  const placeholderUrl = `/placeholder.svg?height=600&width=1200&query=panorama ville de ${cityName} france`

  return (
    <div className={`absolute inset-0 overflow-hidden ${className}`}>
      <Image
        src={placeholderUrl || "/placeholder.svg"}
        alt={`Panorama de ${cityName}`}
        fill
        className="object-cover"
        priority
      />
      {overlay && (
        <div className="absolute inset-0" style={{ backgroundColor: overlayColor, opacity: overlayOpacity }}></div>
      )}
    </div>
  )
}
