"use client"

import Link from "next/link"
import { Button } from "@/components/ui/button"

interface ConsultationCTAProps {
  title: string
  description: string
  buttonText: string
  buttonLink: string
}

export function ConsultationCTA({ title, description, buttonText, buttonLink }: ConsultationCTAProps) {
  return (
    <div className="bg-gradient-to-r from-[#002395] to-[#001875] text-white p-8 rounded-lg text-center">
      <h2 className="text-2xl md:text-3xl font-bold mb-4">{title}</h2>
      <p className="text-lg mb-6 opacity-90">{description}</p>
      <Link href={buttonLink}>
        <Button size="lg" variant="secondary" className="bg-white text-[#002395] hover:bg-gray-100">
          {buttonText}
        </Button>
      </Link>
    </div>
  )
}
