import Image from "next/image"

export default function DefaultVilleImage({ ville, className = "" }: { ville: string; className?: string }) {
  return (
    <div className={`relative bg-gray-200 flex items-center justify-center ${className}`}>
      <Image
        src="/placeholder.svg?key=yl1u2"
        alt={`Image par défaut pour ${ville}`}
        width={600}
        height={400}
        className="w-full h-full object-cover"
      />
      <div className="absolute inset-0 flex items-center justify-center bg-black/30">
        <h3 className="text-white text-xl font-bold">{ville}</h3>
      </div>
    </div>
  )
}
