import Image from "next/image"
import Link from "next/link"
import { ChevronRight } from "lucide-react"

interface City {
  name: string
  image: string
  slug: string
}

export default function NationalPresence() {
  const cities: City[] = [
    { name: "Lyon", image: "/lyon-france-skyline.png", slug: "lyon" },
    { name: "Marseille", image: "/marseille-port.png", slug: "marseille" },
    { name: "Nice", image: "/nice-promenade-des-anglais.png", slug: "nice" },
    { name: "Toulouse", image: "/toulouse-pink-city.png", slug: "toulouse" },
    { name: "Nantes", image: "/nantes-france-city.png", slug: "nantes" },
    { name: "Lille", image: "/lille-grand-place.png", slug: "lille" },
    { name: "Bordeaux", image: "/bordeaux-place-bourse.png", slug: "bordeaux" },
    { name: "Montpellier", image: "/montpellier-place-comedie.png", slug: "montpellier" },
    { name: "Strasbourg", image: "/strasbourg-cathedral.png", slug: "strasbourg" },
    { name: "Aix-en-Provence", image: "/aix-en-provence-fontaine.png", slug: "aix-en-provence" },
  ]

  return (
    <section className="py-12 bg-white">
      <div className="container mx-auto px-4">
        <div className="flex justify-between items-center mb-8">
          <h2 className="text-4xl font-bold bg-gradient-to-r from-[#002395] to-[#001875] bg-clip-text text-transparent">
            Nous sommes présents dans toute la France
          </h2>
          <Link
            href="/services/gestion-locative-france"
            className="text-[#002395] hover:text-[#001875] font-semibold flex items-center"
          >
            Voir toutes les villes <ChevronRight className="ml-1 h-5 w-5" />
          </Link>
        </div>

        <div className="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-4 xl:grid-cols-5 gap-4">
          {cities.map((city) => (
            <Link key={city.slug} href={`/services/gestion-locative-france/${city.slug}`} className="group block">
              <div className="relative overflow-hidden rounded-lg shadow-md h-48 mb-2">
                <Image
                  src={city.image || "/placeholder.svg"}
                  alt={`Gestion locative à ${city.name}`}
                  fill
                  className="object-cover transition-transform duration-300 group-hover:scale-110"
                />
              </div>
              <h3 className="text-center font-medium">Gestion locative à {city.name}</h3>
            </Link>
          ))}
        </div>
      </div>
    </section>
  )
}
