"use client"

import Link from "next/link"
import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card"
import { ArrowRight } from "lucide-react"

export default function ServicesSidebarWidgets() {
  return (
    <Card className="border border-gray-100 shadow-sm mb-6">
      <CardHeader className="pb-3">
        <CardTitle className="text-lg font-bold">Services liés</CardTitle>
      </CardHeader>
      <CardContent className="p-4">
        <div className="space-y-4">
          <Link
            href="/services/gestion-locative"
            className="block p-3 rounded-lg border border-gray-100 hover:border-blue-100 hover:bg-blue-50/30 transition-colors"
          >
            <h4 className="font-medium text-[#002395]">Gestion Locative</h4>
            <p className="text-sm text-gray-600 mt-1">Confiez-nous la gestion complète de votre bien immobilier</p>
            <div className="flex items-center text-sm text-[#002395] mt-2 font-medium">
              En savoir plus <ArrowRight className="ml-1 h-3 w-3" />
            </div>
          </Link>
          <Link
            href="/services/transaction"
            className="block p-3 rounded-lg border border-gray-100 hover:border-blue-100 hover:bg-blue-50/30 transition-colors"
          >
            <h4 className="font-medium text-[#002395]">Transaction Immobilière</h4>
            <p className="text-sm text-gray-600 mt-1">Achat, vente et estimation de biens immobiliers</p>
            <div className="flex items-center text-sm text-[#002395] mt-2 font-medium">
              En savoir plus <ArrowRight className="ml-1 h-3 w-3" />
            </div>
          </Link>
          <Link
            href="/services/garantie-loyers-impayes"
            className="block p-3 rounded-lg border border-gray-100 hover:border-blue-100 hover:bg-blue-50/30 transition-colors"
          >
            <h4 className="font-medium text-[#002395]">Garantie Loyers Impayés</h4>
            <p className="text-sm text-gray-600 mt-1">Protégez vos revenus locatifs contre les impayés</p>
            <div className="flex items-center text-sm text-[#002395] mt-2 font-medium">
              En savoir plus <ArrowRight className="ml-1 h-3 w-3" />
            </div>
          </Link>
        </div>
      </CardContent>
    </Card>
  )
}
