"use client"

import Link from "next/link"
import { Facebook, Instagram, Linkedin } from "lucide-react"

export default function SiteFooter() {
  const currentYear = new Date().getFullYear()

  // Fonction pour gérer les redirections
  const handleRedirect = (e, path) => {
    e.preventDefault()
    window.location.href = path
  }

  return (
    <footer className="bg-gray-900 text-white">
      {/* Main Footer Content */}
      <div className="container mx-auto px-4 py-16">
        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
          {/* Column 1: Logo and Description */}
          <div>
            <div className="flex items-center space-x-3 mb-6">
              <div className="w-12 h-12 bg-[#002395] flex items-center justify-center text-white font-bold text-2xl rounded">
                D
              </div>
              <div className="flex flex-col">
                <span className="text-xl font-bold">DOGES.</span>
                <span className="text-xs">ADMINISTRATEUR DE BIENS</span>
              </div>
            </div>
            <p className="text-gray-400 mb-6">
              Doges est spécialisée dans la gestion immobilière en ligne. Nous proposons des services de qualité à des
              prix uniques en France pour répondre aux besoins de nos clients.
            </p>
            <div className="flex space-x-4 mb-6">
              <Link
                href="https://www.facebook.com/people/Doges/100094123102319/"
                target="_blank"
                rel="noopener noreferrer"
                className="w-10 h-10 rounded-full bg-gray-800 flex items-center justify-center hover:bg-[#002395] transition-colors"
              >
                <Facebook className="h-5 w-5 text-white" />
              </Link>
              <Link
                href="https://www.linkedin.com/company/doges/"
                target="_blank"
                rel="noopener noreferrer"
                className="w-10 h-10 rounded-full bg-gray-800 flex items-center justify-center hover:bg-[#002395] transition-colors"
              >
                <Linkedin className="h-5 w-5 text-white" />
              </Link>
              <Link
                href="#"
                className="w-10 h-10 rounded-full bg-gray-800 flex items-center justify-center hover:bg-[#002395] transition-colors"
              >
                <Instagram className="h-5 w-5 text-white" />
              </Link>
            </div>
            <div>
              <h4 className="font-semibold mb-2">L'agence</h4>
              <p className="text-gray-400 mb-1">92, Avenue de Saint-Mandé Paris 12e</p>
              <a href="tel:0184809810" className="text-gray-400 hover:text-white transition-colors block mb-1">
                Tel : 01 84 80 98 10
              </a>
              <a
                href="mailto:contact@dogesadb.fr"
                className="text-gray-400 hover:text-white transition-colors block mb-1"
              >
                contact@dogesadb.fr
              </a>
            </div>
          </div>

          {/* Column 2: Services */}
          <div>
            <h3 className="font-semibold text-lg mb-4">Services</h3>
            <ul className="space-y-3">
              <li>
                <a
                  href="/services/gestion-locative"
                  className="text-gray-400 hover:text-white transition-colors"
                  onClick={(e) => handleRedirect(e, "/services/gestion-locative")}
                >
                  Gestion locative
                </a>
              </li>
              <li>
                <a
                  href="/services/transaction"
                  className="text-gray-400 hover:text-white transition-colors"
                  onClick={(e) => handleRedirect(e, "/services/transaction")}
                >
                  Transaction
                </a>
              </li>
              <li>
                <a
                  href="/services/juridique"
                  className="text-gray-400 hover:text-white transition-colors"
                  onClick={(e) => handleRedirect(e, "/services/juridique")}
                >
                  Juridique
                </a>
              </li>
              <li>
                <a
                  href="/services/garantie-loyers-impayes"
                  className="text-gray-400 hover:text-white transition-colors"
                  onClick={(e) => handleRedirect(e, "/services/garantie-loyers-impayes")}
                >
                  Garantie loyers impayés
                </a>
              </li>
              <li>
                <a
                  href="/services/assurance-pno"
                  className="text-gray-400 hover:text-white transition-colors"
                  onClick={(e) => handleRedirect(e, "/services/assurance-pno")}
                >
                  Assurance PNO
                </a>
              </li>
              <li>
                <a
                  href="/services/service-commercial"
                  className="text-gray-400 hover:text-white transition-colors"
                  onClick={(e) => handleRedirect(e, "/services/service-commercial")}
                >
                  Service commercial
                </a>
              </li>
              <li>
                <a
                  href="/services/professionnels"
                  className="text-gray-400 hover:text-white transition-colors"
                  onClick={(e) => handleRedirect(e, "/services/professionnels")}
                >
                  Professionnels
                </a>
              </li>
            </ul>
          </div>

          {/* Column 3: Contact & Ressources (déplacé avant À propos) */}
          <div>
            <h3 className="font-semibold text-lg mb-4">Contact & Ressources</h3>
            <ul className="space-y-3">
              <li>
                <a
                  href="/contact"
                  className="text-gray-400 hover:text-white transition-colors"
                  onClick={(e) => handleRedirect(e, "/contact")}
                >
                  Nous contacter
                </a>
              </li>
              <li>
                <a
                  href="/blog"
                  className="text-gray-400 hover:text-white transition-colors"
                  onClick={(e) => handleRedirect(e, "/blog")}
                >
                  Blog
                </a>
              </li>
              <li>
                <a
                  href="/calculateurs"
                  className="text-gray-400 hover:text-white transition-colors"
                  onClick={(e) => handleRedirect(e, "/calculateurs")}
                >
                  Calculateurs
                </a>
              </li>
              <li>
                <a
                  href="/comparatif-gestionnaires-immobiliers"
                  className="text-gray-400 hover:text-white transition-colors"
                  onClick={(e) => handleRedirect(e, "/comparatif-gestionnaires-immobiliers")}
                >
                  Comparatif gestionnaires
                </a>
              </li>
              <li>
                <a
                  href="/faq"
                  className="text-gray-400 hover:text-white transition-colors"
                  onClick={(e) => handleRedirect(e, "/faq")}
                >
                  FAQ
                </a>
              </li>
              <li>
                <a
                  href="/tarifs"
                  className="text-gray-400 hover:text-white transition-colors"
                  onClick={(e) => handleRedirect(e, "/tarifs")}
                >
                  Tarifs
                </a>
              </li>
              <li>
                <a
                  href="/temoignages"
                  className="text-gray-400 hover:text-white transition-colors"
                  onClick={(e) => handleRedirect(e, "/temoignages")}
                >
                  Témoignages
                </a>
              </li>
            </ul>
          </div>

          {/* Column 4: À propos (déplacé après Contact & Ressources) */}
          <div>
            <h3 className="font-semibold text-lg mb-4">À propos</h3>
            <ul className="space-y-3">
              <li>
                <a
                  href="/a-propos"
                  className="text-gray-400 hover:text-white transition-colors"
                  onClick={(e) => handleRedirect(e, "/a-propos")}
                >
                  À propos
                </a>
              </li>
              <li>
                <a
                  href="/carrieres"
                  className="text-gray-400 hover:text-white transition-colors"
                  onClick={(e) => handleRedirect(e, "/carrieres")}
                >
                  Carrières
                </a>
              </li>
              <li>
                <a
                  href="/espace-client"
                  className="text-gray-400 hover:text-white transition-colors"
                  onClick={(e) => handleRedirect(e, "/espace-client")}
                >
                  Espace Client
                </a>
              </li>
            </ul>
          </div>
        </div>
      </div>

      {/* Bottom Bar */}
      <div className="border-t border-gray-800 py-4">
        <div className="container mx-auto px-4 flex flex-col md:flex-row justify-between items-center">
          <div className="text-gray-500 text-sm mb-4 md:mb-0">© {currentYear} DOGES. Tous droits réservés.</div>
          <div className="flex flex-wrap justify-center md:justify-end gap-4 md:gap-6 text-sm">
            <a
              href="/mentions-legales"
              className="text-gray-500 hover:text-white transition-colors"
              onClick={(e) => handleRedirect(e, "/mentions-legales")}
            >
              Mentions légales
            </a>
            <a
              href="/politique-confidentialite"
              className="text-gray-500 hover:text-white transition-colors"
              onClick={(e) => handleRedirect(e, "/politique-confidentialite")}
              data-testid="politique-confidentialite-link"
            >
              Politique de confidentialité
            </a>
            <a
              href="/plan-site"
              className="text-gray-500 hover:text-white transition-colors"
              onClick={(e) => handleRedirect(e, "/plan-site")}
            >
              Plan du site
            </a>
            <a
              href="https://ntech.tn/"
              target="_blank"
              rel="noopener noreferrer"
              className="text-gray-500 hover:text-white transition-colors"
            >
              Développé par Ntech
            </a>
          </div>
        </div>
      </div>
    </footer>
  )
}
