"use client"

// Vérifier et uniformiser le composant TableOfContentsWidget
import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card"
import { List } from "lucide-react"

interface TableOfContentsWidgetProps {
  items: {
    id: string
    title: string
  }[]
}

export default function TableOfContentsWidget({ items }: TableOfContentsWidgetProps) {
  return (
    <Card className="border border-gray-100 shadow-sm mb-6">
      <CardHeader className="pb-3">
        <div className="flex items-center">
          <List className="h-5 w-5 text-[#002395] mr-2" />
          <CardTitle className="text-lg font-bold">Sommaire</CardTitle>
        </div>
      </CardHeader>
      <CardContent className="p-4">
        <nav>
          <ul className="space-y-2">
            {items.map((item) => (
              <li key={item.id}>
                <a
                  href={`#${item.id}`}
                  className="block py-1 px-2 rounded-md text-sm transition-colors text-gray-700 hover:bg-gray-50"
                  onClick={(e) => {
                    e.preventDefault()
                    document.getElementById(item.id)?.scrollIntoView({
                      behavior: "smooth",
                    })
                    // Update URL without page reload
                    window.history.pushState(null, "", `#${item.id}`)
                  }}
                >
                  {item.title}
                </a>
              </li>
            ))}
          </ul>
        </nav>
      </CardContent>
    </Card>
  )
}
