"use client"

import { cn } from "@/lib/utils"
import { useEffect, useState } from "react"

interface TableOfContentsProps {
  items: Array<{
    id: string
    text?: string
    title?: string
    url?: string
    level?: number
  }>
}

export function TableOfContents({ items }: TableOfContentsProps) {
  const [activeId, setActiveId] = useState<string>("")

  useEffect(() => {
    const handleScroll = () => {
      const headings = items
        .map((item) => {
          const el = document.getElementById(item.id)
          if (!el) return null

          const { top } = el.getBoundingClientRect()
          return { id: item.id, top }
        })
        .filter(Boolean) as Array<{ id: string; top: number }>

      const activeHeading = headings.find((heading) => heading.top > 0)
      setActiveId(activeHeading ? activeHeading.id : items[0]?.id || "")
    }

    handleScroll()
    window.addEventListener("scroll", handleScroll, { passive: true })

    return () => {
      window.removeEventListener("scroll", handleScroll)
    }
  }, [items])

  return (
    <div className="space-y-2">
      {items.map((item) => {
        const text = item.text || item.title || ""
        const url = item.url || `#${item.id}`
        const level = item.level || 2

        return (
          <div
            key={item.id}
            className={cn(
              "text-sm transition-colors hover:text-foreground",
              activeId === item.id ? "font-medium text-foreground" : "text-muted-foreground",
              level === 3 && "ml-4",
            )}
          >
            <a href={url}>{text}</a>
          </div>
        )
      })}
    </div>
  )
}
