"use client"
import { Dialog, DialogContent, DialogHeader, DialogTitle, DialogTrigger } from "@/components/ui/dialog"
import { Button } from "@/components/ui/button"
import { EyeIcon as Eye360 } from "lucide-react"

export default function VirtualTour({ tourUrl }: { tourUrl: string }) {
  return (
    <Dialog>
      <DialogTrigger asChild>
        <Button variant="outline" className="gap-2">
          <Eye360 className="h-4 w-4" />
          Visite virtuelle
        </Button>
      </DialogTrigger>
      <DialogContent className="sm:max-w-[900px] h-[80vh]">
        <DialogHeader>
          <DialogTitle>Visite virtuelle</DialogTitle>
        </DialogHeader>
        <div className="relative h-full w-full">
          <iframe src={tourUrl} className="absolute inset-0 w-full h-full" frameBorder="0" allowFullScreen />
        </div>
      </DialogContent>
    </Dialog>
  )
}
