// Audit complet des articles du blog
// Ce fichier liste tous les articles existants vs affichés

// Articles actuellement AFFICHÉS dans blog-utils.ts (17 articles)
export const displayedArticles = [
  // GESTION LOCATIVE (4 articles)
  "guide-proprietaire-bailleur-2025",
  "erreurs-gestion-locative-eviter",
  "colocation-avantages-fiscaux-gestion",
  "eviter-impayes-loyer-guide",

  // FISCALITÉ (4 articles)
  "optimisation-fiscale-proprietaires-2025",
  "lmnp-lmp-comparaison-statuts",
  "avantages-fiscaux-location-meublee",
  "ifi-immobilier-locatif",

  // INVESTISSEMENT (4 articles)
  "investir-immobilier-ile-de-france-2025",
  "meilleurs-quartiers-paris-investir-2025",
  "calculer-rentabilite-investissement-locatif-paris",
  "investir-ancien-vs-neuf-ile-de-france",

  // RÉGLEMENTATION (4 articles)
  "obligations-energetiques-proprietaires-2025",
  "dpe-2024-changements-proprietaires",
  "encadrement-loyers-paris-bilan",
  "obligations-transition-energetique",

  // RÉNOVATION (1 article)
  "travaux-renovation-valeur-locative",
]

// Articles existants mais NON AFFICHÉS (trouvés dans le code)
export const hiddenArticles = [
  // Articles avec des fichiers existants mais non listés
  "gestion-locative-soi-meme-ou-deleguer", // Existe mais problématique
  "exemple-howto-guide", // Article template/exemple
  "_template-article", // Template pour nouveaux articles
]

// Articles potentiellement cassés ou incomplets
export const problematicArticles = [
  "assurance-loyers-impayes-2024", // Mentionné mais fichier manquant ou problématique
]

// RÉSUMÉ DE L'AUDIT
export const blogAudit = {
  totalDisplayed: displayedArticles.length, // 17 articles
  totalHidden: hiddenArticles.length, // 3 articles
  totalProblematic: problematicArticles.length, // 1 article
  totalFiles: displayedArticles.length + hiddenArticles.length, // 20 fichiers existants

  // Répartition par catégorie des articles affichés
  categoriesCount: {
    "Gestion locative": 4,
    Fiscalité: 4,
    Investissement: 4,
    Réglementation: 4,
    Rénovation: 1,
    Assurance: 0, // Supprimé car problématique
  },

  // Recommandations
  recommendations: [
    "Supprimer ou corriger les 3 articles cachés",
    "Créer un nouvel article d'assurance fonctionnel",
    "Nettoyer les templates et exemples",
    "Équilibrer les catégories (ajouter plus d'articles Rénovation)",
  ],
}

// Fonction pour afficher l'audit
export function displayAudit() {
  console.log("=== AUDIT DU BLOG DOGES ===")
  console.log(`📊 Articles affichés: ${blogAudit.totalDisplayed}`)
  console.log(`👻 Articles cachés: ${blogAudit.totalHidden}`)
  console.log(`❌ Articles problématiques: ${blogAudit.totalProblematic}`)
  console.log(`📁 Total fichiers: ${blogAudit.totalFiles}`)
  console.log("\n📈 Répartition par catégorie:")
  Object.entries(blogAudit.categoriesCount).forEach(([cat, count]) => {
    console.log(`  ${cat}: ${count} articles`)
  })
  console.log("\n💡 Recommandations:")
  blogAudit.recommendations.forEach((rec, i) => {
    console.log(`  ${i + 1}. ${rec}`)
  })
}
