import type { RelatedArticle } from "@/components/related-articles-cards"
import { getArticleImage } from "./blog-images"

// Liste nettoyée des articles qui existent réellement et fonctionnent
export const blogArticles = [
  // GESTION LOCATIVE (5 articles vérifiés)
  {
    slug: "guide-proprietaire-bailleur-2025",
    title: "Guide complet du propriétaire bailleur en 2025",
    description: "Tout ce que vous devez savoir pour gérer efficacement votre bien locatif en 2025.",
    image: "/professional-property-management.jpg",
    date: "15 mars 2025",
    category: "Gestion locative",
    readingTime: "15 min",
  },
  {
    slug: "gestion-locative-soi-meme-ou-deleguer",
    title: "Gestion Locative : Faire Soi-même ou Déléguer en 2025 ?",
    description:
      "Comparatif détaillé entre autogestion et gestion déléguée pour votre bien locatif en 2025. Avantages, inconvénients et conseils pour faire le bon choix.",
    image: "/property-keys-handover.jpg",
    date: "5 mars 2025",
    category: "Gestion locative",
    readingTime: "8 min",
  },
  {
    slug: "erreurs-gestion-locative-eviter",
    title: "Les erreurs de gestion locative à éviter",
    description: "Conseils pratiques pour éviter les pièges courants de la gestion locative.",
    image: "/property-management-team-discuss.png",
    date: "15 février 2025",
    category: "Gestion locative",
    readingTime: "7 min",
  },
  {
    slug: "colocation-avantages-fiscaux-gestion",
    title: "La colocation : avantages fiscaux et gestion",
    description: "Comment maximiser vos revenus et simplifier la gestion de vos biens en colocation.",
    image: "/shared-living-space.png",
    date: "15 janvier 2025",
    category: "Gestion locative",
    readingTime: "9 min",
  },
  {
    slug: "eviter-impayes-loyer-guide",
    title: "Comment éviter les impayés de loyer : guide complet",
    description: "Stratégies préventives et solutions pour sécuriser vos revenus locatifs.",
    image: "/rental-income-protection-security.png",
    date: "1 janvier 2025",
    category: "Gestion locative",
    readingTime: "9 min",
  },

  // FISCALITÉ (4 articles vérifiés)
  {
    slug: "optimisation-fiscale-proprietaires-2025",
    title: "Optimisation Fiscale pour Propriétaires en 2025",
    description: "Stratégies avancées pour réduire votre fiscalité immobilière et maximiser votre rentabilité.",
    image: "/fiscal-calculation-meeting.png",
    date: "12 mars 2025",
    category: "Fiscalité",
    readingTime: "13 min",
  },
  {
    slug: "lmnp-lmp-comparaison-statuts",
    title: "LMNP vs LMP : Comparaison des statuts pour la location meublée",
    description: "Analyse détaillée des avantages et inconvénients de chaque statut fiscal.",
    image: "/real-lmnp-lmp-comparison.jpg",
    date: "1 février 2025",
    category: "Fiscalité",
    readingTime: "12 min",
  },
  {
    slug: "avantages-fiscaux-location-meublee",
    title: "Les avantages fiscaux de la location meublée",
    description: "Optimisez votre fiscalité grâce au statut LMNP et aux amortissements.",
    image: "/real-furnished-rental.jpg",
    date: "20 janvier 2025",
    category: "Fiscalité",
    readingTime: "10 min",
  },
  {
    slug: "ifi-immobilier-locatif",
    title: "IFI et immobilier locatif : stratégies d'optimisation",
    description: "Comment réduire votre Impôt sur la Fortune Immobilière tout en développant votre patrimoine.",
    image: "/ifi-tax-calculation.png",
    date: "10 janvier 2025",
    category: "Fiscalité",
    readingTime: "11 min",
  },

  // INVESTISSEMENT (4 articles vérifiés)
  {
    slug: "investir-immobilier-ile-de-france-2025",
    title: "Où Investir dans l'Immobilier en Île-de-France en 2025 ?",
    description: "Analyse des meilleures opportunités d'investissement immobilier en Île-de-France pour 2025.",
    image: "/paris-investment-2025.png",
    date: "3 décembre 2024",
    category: "Investissement",
    readingTime: "15 min",
  },
  {
    slug: "meilleurs-quartiers-paris-investir-2025",
    title: "Les Meilleurs Quartiers de Paris pour Investir en 2025",
    description: "Découvrez les zones parisiennes les plus prometteuses pour votre investissement locatif.",
    image: "/paris-arrondissements-map.png",
    date: "15 novembre 2024",
    category: "Investissement",
    readingTime: "14 min",
  },
  {
    slug: "calculer-rentabilite-investissement-locatif-paris",
    title: "Comment calculer la rentabilité d'un investissement locatif à Paris",
    description: "Méthodes et outils pour évaluer précisément le rendement de votre investissement immobilier.",
    image: "/rentabilite-calcul-professionnel.png",
    date: "10 février 2025",
    category: "Investissement",
    readingTime: "13 min",
  },
  {
    slug: "investir-ancien-vs-neuf-ile-de-france",
    title: "Investir dans l'ancien ou le neuf en Île-de-France",
    description: "Analyse comparative pour vous aider à faire le meilleur choix d'investissement.",
    image: "/real-old-vs-new-property.jpg",
    date: "5 février 2025",
    category: "Investissement",
    readingTime: "14 min",
  },

  // RÉGLEMENTATION (4 articles vérifiés)
  {
    slug: "obligations-energetiques-proprietaires-2025",
    title: "Nouvelles Obligations Énergétiques pour les Propriétaires en 2025",
    description: "Tout ce que vous devez savoir sur les nouvelles réglementations énergétiques.",
    image: "/dpe-diagnostic-complet.png",
    date: "8 mars 2025",
    category: "Réglementation",
    readingTime: "11 min",
  },
  {
    slug: "dpe-2024-changements-proprietaires",
    title: "Les nouvelles obligations du DPE en 2025",
    description: "Tout ce que vous devez savoir sur les évolutions du Diagnostic de Performance Énergétique.",
    image: "/maison-verte-dpe.png",
    date: "10 mars 2025",
    category: "Réglementation",
    readingTime: "8 min",
  },
  {
    slug: "encadrement-loyers-paris-bilan",
    title: "Bilan de l'encadrement des loyers à Paris",
    description: "Analyse des impacts de l'encadrement des loyers sur le marché immobilier parisien.",
    image: "/paris-arrondissements-map.png",
    date: "28 février 2025",
    category: "Réglementation",
    readingTime: "18 min",
  },
  {
    slug: "obligations-transition-energetique",
    title: "Obligations de transition énergétique pour les propriétaires",
    description: "Les nouvelles normes environnementales et leurs implications pour votre patrimoine immobilier.",
    image: "/dpe-energy-label.png",
    date: "20 février 2025",
    category: "Réglementation",
    readingTime: "11 min",
  },

  // RÉNOVATION (1 article vérifié)
  {
    slug: "travaux-renovation-valeur-locative",
    title: "Travaux de rénovation et valeur locative",
    description: "Les investissements qui augmentent réellement la valeur et le rendement de votre bien.",
    image: "/renovation-in-progress.png",
    date: "5 janvier 2025",
    category: "Rénovation",
    readingTime: "10 min",
  },
]

// Fonction pour obtenir les articles liés par catégorie
export function getRelatedArticles(currentSlug: string, category: string, limit = 2): RelatedArticle[] {
  return blogArticles
    .filter((article) => article.slug !== currentSlug && article.category === category)
    .slice(0, limit)
    .map((article) => ({
      slug: article.slug,
      title: article.title,
      description: article.description,
      image: article.image,
      date: article.date,
    }))
}

// Fonction pour obtenir l'article précédent
export function getPreviousArticle(currentSlug: string) {
  const currentIndex = blogArticles.findIndex((article) => article.slug === currentSlug)
  if (currentIndex <= 0) return null

  const prevArticle = blogArticles[currentIndex - 1]
  return {
    slug: prevArticle.slug,
    title: prevArticle.title,
  }
}

// Fonction pour obtenir l'article suivant
export function getNextArticle(currentSlug: string) {
  const currentIndex = blogArticles.findIndex((article) => article.slug === currentSlug)
  if (currentIndex === -1 || currentIndex >= blogArticles.length - 1) return null

  const nextArticle = blogArticles[currentIndex + 1]
  return {
    slug: nextArticle.slug,
    title: nextArticle.title,
  }
}

// Réexporter la fonction pour maintenir la compatibilité
export { getArticleImage }
