export interface FAQItem {
  id: string
  category: string
  question: string
  answer: string
  keywords: string[]
}

// Données de la FAQ extraites de la page FAQ
export const faqData: FAQItem[] = [
  {
    id: "q1",
    category: "gestion",
    question: "Quels sont les services inclus dans la gestion locative ?",
    answer:
      "Notre service de gestion locative comprend la recherche de locataires, la rédaction des baux, l'état des lieux, l'encaissement des loyers, la gestion des travaux et le suivi administratif complet. Selon le forfait choisi, des services supplémentaires peuvent être inclus comme la garantie loyers impayés, l'assurance PNO ou la représentation en assemblée générale.",
    keywords: ["gestion locative", "services", "inclus", "forfait", "bail", "loyer", "travaux", "administratif"],
  },
  {
    id: "q2",
    category: "transaction",
    question: "Comment est calculée la commission sur les transactions ?",
    answer:
      "Notre commission est calculée en pourcentage du prix de vente du bien. Elle inclut l'ensemble de nos services : estimation, marketing, visites, négociation et suivi jusqu'à la signature. Le taux varie généralement entre 4% et 5% TTC selon le type et la valeur du bien. Pour un bien de grande valeur, ce taux peut être négocié.",
    keywords: ["commission", "transaction", "vente", "pourcentage", "tarif", "honoraires", "négociation"],
  },
  {
    id: "q3",
    category: "gestion",
    question: "Quelle est la durée d'engagement pour la gestion locative ?",
    answer:
      "Notre mandat de gestion est généralement d'une durée d'un an, renouvelable par tacite reconduction. Vous pouvez le résilier selon les conditions prévues au contrat, généralement avec un préavis de trois mois. Nous privilégions des relations de confiance sur le long terme avec nos clients.",
    keywords: ["durée", "engagement", "mandat", "gestion", "contrat", "préavis", "résiliation"],
  },
  {
    id: "q4",
    category: "gli",
    question: "Comment fonctionne la garantie loyers impayés ?",
    answer:
      "La garantie loyers impayés (GLI) est une assurance qui couvre le propriétaire en cas d'impayés de loyer. Elle prend en charge les loyers impayés, les frais de procédure et parfois les dégradations locatives. Pour en bénéficier, le locataire doit répondre à certains critères de solvabilité. Le coût est généralement de 2,5% à 3,5% des loyers annuels.",
    keywords: ["garantie", "loyers impayés", "GLI", "assurance", "impayés", "solvabilité", "couverture"],
  },
  {
    id: "q5",
    category: "pno",
    question: "Qu'est-ce que l'assurance PNO et pourquoi est-elle nécessaire ?",
    answer:
      "L'assurance Propriétaire Non Occupant (PNO) est obligatoire pour tout propriétaire qui loue son bien. Elle couvre les risques liés à la propriété du bien (dégâts des eaux, incendie, responsabilité civile, etc.) qui ne sont pas couverts par l'assurance du locataire. Son coût varie généralement entre 80€ et 150€ par an selon la superficie et les garanties choisies.",
    keywords: ["assurance", "PNO", "propriétaire non occupant", "obligatoire", "risques", "dégâts", "responsabilité"],
  },
  {
    id: "q6",
    category: "gestion",
    question: "Comment se passe la recherche de locataires ?",
    answer:
      "Nous mettons en place une stratégie de commercialisation complète : annonces sur les principaux portails immobiliers, diffusion sur notre site et nos réseaux sociaux, et activation de notre réseau de candidats. Nous effectuons une présélection rigoureuse des dossiers, organisons les visites et vous présentons les meilleurs candidats pour validation finale.",
    keywords: ["recherche", "locataires", "commercialisation", "annonces", "visites", "dossiers", "sélection"],
  },
  {
    id: "q7",
    category: "transaction",
    question: "Quels sont les délais moyens pour vendre un bien ?",
    answer:
      "Les délais de vente varient selon le type de bien, sa localisation, son état et son prix. À Paris, le délai moyen est d'environ 45 à 60 jours entre la mise en vente et la signature du compromis. Notre connaissance approfondie du marché et notre réseau nous permettent souvent de réduire ce délai pour nos clients.",
    keywords: ["délai", "vente", "bien", "compromis", "signature", "marché", "paris"],
  },
  {
    id: "q8",
    category: "gestion",
    question: "Comment sont gérés les travaux dans le bien loué ?",
    answer:
      "Pour les petits travaux d'entretien, nous disposons d'un réseau d'artisans qualifiés qui interviennent rapidement. Pour les travaux plus importants, nous vous consultons systématiquement et vous proposons plusieurs devis. Nous assurons ensuite le suivi des travaux jusqu'à leur bonne exécution et vous tenons informé à chaque étape.",
    keywords: ["travaux", "entretien", "artisans", "devis", "suivi", "réparation", "intervention"],
  },
  {
    id: "q9",
    category: "syndic",
    question: "Quels sont les avantages de faire appel à un syndic professionnel ?",
    answer:
      "Un syndic professionnel comme DOGES apporte une expertise juridique et technique, une disponibilité et une réactivité accrues, ainsi qu'une gestion rigoureuse des comptes de la copropriété. Nous assurons également une veille réglementaire constante pour garantir la conformité de votre copropriété avec les évolutions législatives.",
    keywords: ["syndic", "professionnel", "copropriété", "avantages", "expertise", "juridique", "gestion"],
  },
  {
    id: "q10",
    category: "gestion",
    question: "Comment est calculé le loyer d'un bien ?",
    answer:
      "Le loyer est déterminé en fonction de plusieurs critères : la localisation du bien, sa superficie, son état, ses équipements, et les prix du marché local. Dans certaines zones tendues, le loyer peut être encadré par la loi. Nous réalisons une étude de marché précise pour vous proposer un loyer optimal, attractif pour les locataires tout en maximisant votre rentabilité.",
    keywords: ["loyer", "calcul", "prix", "marché", "encadrement", "rentabilité", "étude"],
  },
  {
    id: "q11",
    category: "gli",
    question: "Quelles sont les conditions pour bénéficier de la garantie loyers impayés ?",
    answer:
      "Pour bénéficier de la GLI, le locataire doit généralement justifier d'un taux d'effort (ratio loyer/revenus) inférieur à 33%, être en CDI hors période d'essai ou avoir un statut stable (fonctionnaire, retraité), et ne pas avoir d'incidents de paiement récents. Ces critères peuvent varier selon les assureurs avec lesquels nous travaillons.",
    keywords: ["conditions", "garantie", "loyers impayés", "GLI", "taux d'effort", "CDI", "solvabilité"],
  },
  {
    id: "q12",
    category: "syndic",
    question: "Comment se déroule une assemblée générale de copropriété ?",
    answer:
      "L'assemblée générale est convoquée au moins 21 jours à l'avance avec un ordre du jour détaillé. Lors de la réunion, le syndic présente les résolutions à voter. Chaque copropriétaire dispose d'un nombre de voix proportionnel à ses tantièmes. Les décisions sont prises à différentes majorités selon leur nature. Un procès-verbal est ensuite établi et envoyé à tous les copropriétaires.",
    keywords: ["assemblée générale", "copropriété", "convocation", "résolutions", "vote", "tantièmes", "majorité"],
  },
  {
    id: "q13",
    category: "pno",
    question: "Que faire en cas de sinistre dans mon bien loué ?",
    answer:
      "En cas de sinistre, contactez-nous immédiatement. Nous nous chargeons de faire les déclarations nécessaires auprès des assurances concernées (PNO, assurance du locataire, assurance de l'immeuble), de mandater les experts si nécessaire et de coordonner les travaux de remise en état. Nous vous tenons informé à chaque étape de la procédure.",
    keywords: ["sinistre", "dégât", "assurance", "PNO", "déclaration", "expert", "remise en état"],
  },
  {
    id: "q14",
    category: "transaction",
    question: "Comment est organisée la visite d'un bien à vendre ?",
    answer:
      "Nous organisons les visites en fonction de vos disponibilités et de celles des acquéreurs potentiels. Nous préparons un dossier de présentation complet du bien et de son environnement. Lors de la visite, notre conseiller met en valeur les atouts du bien et répond aux questions des visiteurs. Un compte-rendu vous est ensuite transmis après chaque visite.",
    keywords: ["visite", "vente", "organisation", "présentation", "acquéreurs", "compte-rendu", "dossier"],
  },
  {
    id: "q15",
    category: "gestion",
    question: "Quelles sont les obligations du propriétaire en matière de diagnostics ?",
    answer:
      "Plusieurs diagnostics sont obligatoires pour la location ou la vente d'un bien : DPE, amiante, plomb, électricité, gaz, état des risques naturels et technologiques, etc. La liste varie selon l'âge du bien et sa localisation. Nous vous accompagnons dans la réalisation de ces diagnostics en faisant appel à des diagnostiqueurs certifiés partenaires.",
    keywords: ["diagnostics", "obligatoire", "DPE", "amiante", "plomb", "électricité", "risques"],
  },
  {
    id: "q16",
    category: "specifique",
    question: "Comment DOGES gère-t-il les logements soumis à l'encadrement des loyers à Paris ?",
    answer:
      "Pour les logements situés à Paris soumis à l'encadrement des loyers, nous déterminons précisément le loyer de référence selon les critères officiels (quartier, année de construction, meublé/non meublé). Nous calculons le loyer maximum autorisé en tenant compte du complément de loyer justifié par des caractéristiques exceptionnelles. Nous veillons à la conformité des annonces avec la mention du loyer de référence et nous assurons que les baux respectent la réglementation en vigueur. Notre expertise du marché parisien nous permet de fixer un loyer optimal tout en restant dans le cadre légal.",
    keywords: ["encadrement", "loyers", "paris", "loyer de référence", "complément", "réglementation", "annonces"],
  },
  {
    id: "q17",
    category: "specifique",
    question: "Quelles sont les spécificités de la gestion locative dans le 16ème arrondissement de Paris ?",
    answer:
      "La gestion locative dans le 16ème arrondissement présente plusieurs particularités : une clientèle exigeante composée souvent d'expatriés et de cadres supérieurs, des biens de standing nécessitant un suivi qualitatif, et des copropriétés avec des règlements stricts. Nous adaptons notre gestion avec un interlocuteur dédié parlant anglais, des visites plus fréquentes pour vérifier l'état du bien, et une connaissance approfondie des spécificités du marché local (prix au m², attentes des locataires). Notre agence située à proximité nous permet d'intervenir rapidement en cas de besoin et d'entretenir des relations privilégiées avec les gardiens d'immeubles du quartier.",
    keywords: ["16ème", "arrondissement", "paris", "standing", "expatriés", "spécificités", "gestion locative"],
  },
  {
    id: "q18",
    category: "specifique",
    question: "Comment DOGES accompagne les propriétaires pour la mise en conformité DPE avant 2025 ?",
    answer:
      "Face à l'interdiction progressive de location des passoires thermiques (DPE F et G), nous proposons un accompagnement complet : réalisation d'un audit énergétique détaillé, élaboration d'un plan de travaux hiérarchisé et chiffré, mise en relation avec des artisans certifiés RGE, montage des dossiers d'aides financières (MaPrimeRénov', CEE, éco-PTZ), suivi et coordination des travaux, et contrôle post-travaux avec nouveau DPE. Nous pouvons également conseiller sur la rentabilité des investissements énergétiques et leur impact sur la valorisation du bien. Notre objectif est de transformer cette contrainte réglementaire en opportunité d'amélioration de votre patrimoine.",
    keywords: ["DPE", "2025", "passoire thermique", "conformité", "travaux", "rénovation énergétique", "aides"],
  },
  {
    id: "q19",
    category: "specifique",
    question: "Quelles garanties spécifiques propose DOGES pour les propriétaires de logements de luxe ?",
    answer:
      "Pour les biens haut de gamme, nous proposons des garanties renforcées : une sélection ultra-rigoureuse des locataires avec vérification approfondie des références bancaires et professionnelles, une garantie loyers impayés premium couvrant jusqu'à 10 000€ de loyer mensuel, une assurance PNO ��tendue incluant les biens d'exception et œuvres d'art, des états des lieux réalisés par un expert en objets de valeur, et un service de conciergerie pour la maintenance. Nous effectuons également des visites de contrôle trimestrielles et proposons une garantie de remise en état complète en fin de bail. Ces services premium sont assurés par notre équipe dédiée aux biens d'exception.",
    keywords: ["luxe", "haut de gamme", "garanties", "premium", "conciergerie", "sélection", "biens d'exception"],
  },
  {
    id: "q20",
    category: "specifique",
    question: "Comment DOGES gère-t-il les locations saisonnières et Airbnb à Paris ?",
    answer:
      "Notre gestion des locations saisonnières et Airbnb comprend : la vérification de la conformité légale (autorisation de changement d'usage, déclaration en mairie, respect des 120 jours maximum pour résidence principale), l'optimisation de l'annonce avec photographies professionnelles et description multilingue, la gestion complète des réservations et du calendrier sur les plateformes, l'accueil des voyageurs 7j/7 avec remise des clés, le ménage et la blanchisserie entre chaque séjour, et un reporting mensuel détaillé des performances. Nous gérons également la déclaration fiscale de vos revenus locatifs et vous conseillons sur le statut fiscal le plus avantageux (LMNP, micro-BIC). Notre connaissance des réglementations parisiennes vous évite tout risque d'amende.",
    keywords: ["saisonnière", "Airbnb", "courte durée", "changement d'usage", "120 jours", "gestion", "fiscalité"],
  },
]

// Fonction pour rechercher dans la FAQ
export function searchFAQ(query: string): FAQItem[] {
  const queryLower = query.toLowerCase()
  return faqData
    .filter(
      (item) =>
        item.question.toLowerCase().includes(queryLower) ||
        item.answer.toLowerCase().includes(queryLower) ||
        item.keywords.some((keyword) => queryLower.includes(keyword.toLowerCase())),
    )
    .slice(0, 3)
}

// Fonction pour obtenir les FAQ par catégorie
export function getFAQByCategory(category: string): FAQItem[] {
  return faqData.filter((item) => item.category === category)
}
