const fs = require("fs")
const path = require("path")

// Articles définis dans blog-utils.ts avec leurs images
const expectedArticles = [
  { slug: "guide-proprietaire-bailleur-2025", image: "/professional-property-management.jpg" },
  { slug: "gestion-locative-soi-meme-ou-deleguer", image: "/property-keys-handover.jpg" },
  { slug: "erreurs-gestion-locative-eviter", image: "/property-management-team-discuss.png" },
  { slug: "colocation-avantages-fiscaux-gestion", image: "/shared-living-space.png" },
  { slug: "eviter-impayes-loyer-guide", image: "/rental-income-protection-security.png" },
  { slug: "optimisation-fiscale-proprietaires-2025", image: "/fiscal-calculation-meeting.png" },
  { slug: "lmnp-lmp-comparaison-statuts", image: "/real-lmnp-lmp-comparison.jpg" },
  { slug: "avantages-fiscaux-location-meublee", image: "/real-furnished-rental.jpg" },
  { slug: "ifi-immobilier-locatif", image: "/ifi-tax-calculation.png" },
  { slug: "investir-immobilier-ile-de-france-2025", image: "/paris-investment-2025.png" },
  { slug: "meilleurs-quartiers-paris-investir-2025", image: "/paris-arrondissements-map.png" },
  { slug: "calculer-rentabilite-investissement-locatif-paris", image: "/rentabilite-calcul-professionnel.png" },
  { slug: "investir-ancien-vs-neuf-ile-de-france", image: "/real-old-vs-new-property.jpg" },
  { slug: "obligations-energetiques-proprietaires-2025", image: "/dpe-diagnostic-complet.png" },
  { slug: "dpe-2024-changements-proprietaires", image: "/maison-verte-dpe.png" },
  { slug: "encadrement-loyers-paris-bilan", image: "/paris-arrondissements-map.png" },
  { slug: "obligations-transition-energetique", image: "/dpe-energy-label.png" },
  { slug: "travaux-renovation-valeur-locative", image: "/renovation-in-progress.png" },
]

console.log("🔍 VÉRIFICATION COMPLÈTE DU BLOG")
console.log("================================")

let totalErrors = 0
let totalWarnings = 0

// Vérification de l'existence des fichiers d'articles
console.log("\n📁 Vérification de l'existence des articles:")
expectedArticles.forEach((article) => {
  const filePath = path.join(process.cwd(), "app", "blog", "articles", article.slug, "page.tsx")
  if (fs.existsSync(filePath)) {
    console.log(`✅ ${article.slug} - Fichier existe`)

    // Vérification du contenu du fichier
    const content = fs.readFileSync(filePath, "utf8")

    // Vérifier si l'image est utilisée dans le BlogArticleLayout
    const imageRegex = /image=["']([^"']+)["']/
    const imageMatch = content.match(imageRegex)

    if (imageMatch) {
      const usedImage = imageMatch[1]
      if (usedImage === article.image) {
        console.log(`  ✅ Image correcte: ${usedImage}`)
      } else {
        console.log(`  ❌ Image incorrecte: attendue "${article.image}", trouvée "${usedImage}"`)
        totalErrors++
      }
    } else {
      console.log(`  ⚠️  Aucune image trouvée dans BlogArticleLayout`)
      totalWarnings++
    }

    // Vérifier si tableOfContents est présent
    if (content.includes("tableOfContents={")) {
      console.log(`  ✅ Sommaire présent`)
    } else {
      console.log(`  ⚠️  Sommaire manquant`)
      totalWarnings++
    }

    // Vérifier si author est présent
    if (content.includes("author={")) {
      console.log(`  ✅ Auteur présent`)
    } else {
      console.log(`  ⚠️  Auteur manquant`)
      totalWarnings++
    }
  } else {
    console.log(`❌ ${article.slug} - Fichier manquant`)
    totalErrors++
  }
})

// Vérification des images dans le dossier public
console.log("\n🖼️  Vérification de l'existence des images:")
const uniqueImages = [...new Set(expectedArticles.map((a) => a.image))]
uniqueImages.forEach((imagePath) => {
  const fullPath = path.join(process.cwd(), "public", imagePath.substring(1))
  if (fs.existsSync(fullPath)) {
    console.log(`✅ ${imagePath} - Image existe`)
  } else {
    console.log(`❌ ${imagePath} - Image manquante`)
    totalErrors++
  }
})

// Vérification du fichier blog-utils.ts
console.log("\n📋 Vérification de blog-utils.ts:")
const blogUtilsPath = path.join(process.cwd(), "lib", "blog-utils.ts")
if (fs.existsSync(blogUtilsPath)) {
  console.log(`✅ blog-utils.ts existe`)
  const content = fs.readFileSync(blogUtilsPath, "utf8")

  expectedArticles.forEach((article) => {
    if (content.includes(`slug: "${article.slug}"`)) {
      console.log(`  ✅ ${article.slug} présent dans blog-utils.ts`)
    } else {
      console.log(`  ❌ ${article.slug} manquant dans blog-utils.ts`)
      totalErrors++
    }
  })
} else {
  console.log(`❌ blog-utils.ts manquant`)
  totalErrors++
}

// Résumé final
console.log("\n📊 RÉSUMÉ DE LA VÉRIFICATION:")
console.log("==============================")
console.log(`Total d'articles vérifiés: ${expectedArticles.length}`)
console.log(`Erreurs critiques: ${totalErrors}`)
console.log(`Avertissements: ${totalWarnings}`)

if (totalErrors === 0 && totalWarnings === 0) {
  console.log("\n🎉 PARFAIT! Tous les articles sont correctement configurés!")
} else if (totalErrors === 0) {
  console.log("\n✅ BIEN! Aucune erreur critique, mais quelques améliorations possibles.")
} else {
  console.log("\n⚠️  ATTENTION! Des corrections sont nécessaires avant la finalisation.")
}

console.log("\n🚀 Recommandations pour la finalisation:")
console.log("- Tous les articles doivent avoir la même image que leur carte")
console.log("- Tous les articles doivent avoir un sommaire dans la sidebar")
console.log("- Tous les articles doivent avoir des informations d'auteur")
console.log("- Toutes les images doivent être optimisées (WebP si possible)")
console.log("- Vérifier que tous les liens internes fonctionnent")
