const { execSync } = require("child_process")

function testBuild() {
  console.log("🏗️ Testing build...")

  try {
    // Nettoyer d'abord
    console.log("🧹 Cleaning previous build...")
    try {
      execSync("rm -rf .next", { stdio: "inherit" })
    } catch (error) {
      // Ignorer si le dossier n'existe pas
    }

    // Tenter le build
    console.log("🔨 Running build...")
    execSync("npm run build", { stdio: "inherit", timeout: 300000 }) // 5 minutes timeout

    console.log("✅ Build successful!")
    return true
  } catch (error) {
    console.log("❌ Build failed!")
    console.log("Error output:", error.message)

    // Analyser l'erreur pour donner des conseils
    if (error.message.includes("Can't resolve 'next/Image'")) {
      console.log("\n💡 The error is still related to next/Image imports.")
      console.log("Let me run another comprehensive scan...")
      return false
    }

    return false
  }
}

if (require.main === module) {
  const success = testBuild()
  process.exit(success ? 0 : 1)
}

module.exports = { testBuild }
