const fs = require("fs")
const path = require("path")

// Pages à supprimer (développement/test)
const pagesToDelete = [
  "app/test-route",
  "app/test-components",
  "app/admin/template-generator",
  "app/admin/performance-audit",
  "app/admin/pre-deployment",
  "app/admin/chatbot-manual-test",
  "app/admin/chatbot-test",
  "app/admin/faq-chatbot-test",
  "app/redirect-hauts-de-seine",
  "app/redirect-politique-confidentialite",
  "app/services/administrateur-test",
  "app/api/debug-route",
]

// Pages administrateur de biens à consolider
const adminPagesToReview = [
  "app/services/administrateur-biens-paris-13-14-15",
  "app/services/administrateur-biens-paris-5-6-7",
  "app/services/administrateur-biens-paris-19",
  "app/services/administrateur-biens-paris-centre",
  "app/services/administrateur-biens-paris-8-16-17",
  "app/services/administrateur-biens-paris-9-10-18",
  "app/services/administrateur-biens-paris-11-12-20",
  "app/services/administrateur-biens-immeubles-haussmanniens",
]

console.log("🧹 NETTOYAGE DU SITE - PAGES SUPERFLUES")
console.log("=====================================")

console.log("\n❌ Pages à supprimer (développement/test):")
pagesToDelete.forEach((page) => {
  console.log(`  - ${page}`)
})

console.log("\n⚠️  Pages administrateur de biens à consolider:")
adminPagesToReview.forEach((page) => {
  console.log(`  - ${page}`)
})

console.log("\n💡 RECOMMANDATIONS:")
console.log("1. Supprimer les pages de test/admin")
console.log("2. Garder seulement 3-4 pages admin de biens max")
console.log("3. Consolider le contenu similaire")
console.log("4. Créer des redirections pour les URLs supprimées")

// Fonction pour compter les fichiers
function countFiles(dir) {
  try {
    const files = fs.readdirSync(dir, { recursive: true })
    return files.filter((file) => file.endsWith(".tsx") || file.endsWith(".ts")).length
  } catch {
    return 0
  }
}

console.log("\n📊 STATISTIQUES ACTUELLES:")
console.log(`- Pages app/: ${countFiles("app")} fichiers`)
console.log(`- Composants: ${countFiles("components")} fichiers`)
console.log(`- Scripts: ${countFiles("scripts")} fichiers`)
