#!/bin/bash

echo "🚨 EMERGENCY FIX FOR NEXT/IMAGE IMPORTS 🚨"
echo "=========================================="

# Créer un fichier de redirection dans node_modules
echo "📦 Creating redirect module in node_modules..."
mkdir -p node_modules/next/Image
cat > node_modules/next/Image.js << 'EOF'
// Redirect module for incorrect imports
module.exports = require('next/image');
EOF

echo "✅ Redirect module created!"

# Modifier next.config.mjs pour ajouter l'alias webpack
echo "🔧 Updating webpack configuration..."
if [ -f next.config.mjs ]; then
  # Sauvegarder l'original
  cp next.config.mjs next.config.mjs.bak
  
  # Vérifier si la configuration webpack existe déjà
  if grep -q "webpack:" next.config.mjs; then
    # Ajouter l'alias à la configuration webpack existante
    sed -i 's/webpack: (config, { isServer }) => {/webpack: (config, { isServer }) => {\n    config.resolve.alias = {\n      ...config.resolve.alias,\n      "next\/Image": "next\/image",\n    };/g' next.config.mjs
  else
    # Ajouter une nouvelle configuration webpack
    sed -i 's/const nextConfig = {/const nextConfig = {\n  webpack: (config, { isServer }) => {\n    config.resolve.alias = {\n      ...config.resolve.alias,\n      "next\/Image": "next\/image",\n    };\n    return config;\n  },/g' next.config.mjs
  fi
  
  echo "✅ webpack configuration updated!"
else
  echo "❌ next.config.mjs not found!"
fi

# Nettoyer le cache de build
echo "🧹 Cleaning build cache..."
rm -rf .next
echo "✅ Build cache cleaned!"

echo ""
echo "🚀 Emergency fix completed! Try building again."
