const fs = require("fs")
const path = require("path")

// Liste des images qui pourraient manquer
const possiblyMissingImages = [
  "/dpe-energy-label.png",
  "/energy-consumption-reduction.png",
  "/energy-audit-process.png",
  "/building-renovation-plan.png",
  "/compliance-warning.png",
  "/financial-aid-chart.png",
]

console.log("🔍 VÉRIFICATION DES IMAGES MANQUANTES")
console.log("=====================================")

// Vérifier si les images existent
possiblyMissingImages.forEach((imagePath) => {
  const fullPath = path.join(process.cwd(), "public", imagePath.substring(1))
  if (!fs.existsSync(fullPath)) {
    console.log(`❌ Image manquante: ${imagePath}`)

    // Créer un placeholder pour l'image manquante
    const dir = path.dirname(fullPath)
    if (!fs.existsSync(dir)) {
      fs.mkdirSync(dir, { recursive: true })
    }

    // Créer un fichier texte qui explique que l'image est manquante
    fs.writeFileSync(
      fullPath,
      `Cette image est un placeholder pour ${imagePath}. Veuillez remplacer par l'image réelle.`,
    )
    console.log(`✅ Placeholder créé pour: ${imagePath}`)
  } else {
    console.log(`✅ Image existe: ${imagePath}`)
  }
})

console.log("\n✅ Vérification terminée!")
