// Ce script est fourni à titre d'exemple et devrait être exécuté manuellement
// pour standardiser tous les articles du blog

const fs = require("fs")
const path = require("path")
const { promisify } = require("util")

const readdir = promisify(fs.readdir)
const readFile = promisify(fs.readFile)
const writeFile = promisify(fs.writeFile)
const stat = promisify(fs.stat)

const BLOG_DIR = path.join(__dirname, "../app/blog/articles")
const TEMPLATE = `import { Metadata } from "next"
import BlogArticleLayout from "@/components/blog-article-layout"

export const metadata: Metadata = {
  title: "ARTICLE_TITLE | Dogesadb",
  description: "ARTICLE_DESCRIPTION",
  alternates: {
    canonical: "https://dogesadb.fr/blog/articles/ARTICLE_SLUG",
  },
}

export default function ARTICLE_COMPONENT_NAME() {
  const tableOfContents = [
    // Table des matières à définir
  ]

  return (
    <BlogArticleLayout
      slug="ARTICLE_SLUG"
      title="ARTICLE_TITLE"
      date="ARTICLE_DATE"
      category="ARTICLE_CATEGORY"
      readingTime="ARTICLE_READING_TIME"
      image="ARTICLE_IMAGE"
      tableOfContents={tableOfContents}
    >
      {/* Contenu de l'article */}
    </BlogArticleLayout>
  )
}`

async function isDirectory(path) {
  try {
    const stats = await stat(path)
    return stats.isDirectory()
  } catch (e) {
    return false
  }
}

async function standardizeArticles() {
  try {
    // Lire tous les dossiers d'articles
    const articles = await readdir(BLOG_DIR)

    for (const article of articles) {
      const articlePath = path.join(BLOG_DIR, article)

      // Vérifier si c'est un dossier
      if (await isDirectory(articlePath)) {
        const pagePath = path.join(articlePath, "page.tsx")

        try {
          // Lire le contenu actuel du fichier
          const content = await readFile(pagePath, "utf8")

          // Vérifier si l'article utilise déjà BlogArticleLayout
          if (!content.includes("BlogArticleLayout")) {
            console.log(`Standardisation de l'article: ${article}`)

            // Ici, vous devriez analyser le contenu existant pour extraire les métadonnées
            // et le contenu, puis les reformater selon le template
            // Cette partie nécessiterait une analyse plus complexe du code existant

            // Pour l'exemple, nous nous contentons d'afficher un message
            console.log(`L'article ${article} doit être mis à jour manuellement.`)
          } else {
            console.log(`L'article ${article} utilise déjà le layout standardisé.`)
          }
        } catch (e) {
          console.error(`Erreur lors de la lecture de ${pagePath}:`, e)
        }
      }
    }

    console.log("Processus de standardisation terminé.")
  } catch (e) {
    console.error("Erreur lors de la standardisation des articles:", e)
  }
}

// Exécuter le script
standardizeArticles()
